package com.thebeastshop.stock.enums;

import java.util.Objects;

/**
 * 虚拟库存类型
 */
public enum SVirtualStockType {
    INTEREST(1, "权益")
    ;
    private final Integer code;

    private final String name;

    SVirtualStockType(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static SVirtualStockType findByCode(Integer code) {
        for (SVirtualStockType stockType : SVirtualStockType.values()) {
            if (Objects.equals(code, stockType.code)) {
                return stockType;
            }
        }
        return null;
    }
}
