package com.thebeastshop.stock.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.utils.EmptyUtil;

/**
 *月送鲜花城市数据
 */
public class SFlowerMonthlyCityDTO extends BaseDO{

  private String skuCode;

  private Integer capacityQuantity;
  private Integer soldQuantity;
  private Integer canUseQuantity;
  private Integer tasksQuantity;
  private Integer cityId;
  private String cityName;
  private Byte productionType;
  private String physicalWarehouseCode;

  public String getSkuCode() {
    return skuCode;
  }

  public void setSkuCode(String skuCode) {
    this.skuCode = skuCode;
  }



  public Integer getCityId() {
    return cityId;
  }

  public void setCityId(Integer cityId) {
    this.cityId = cityId;
  }

  public Byte getProductionType() {
    return productionType;
  }

  public void setProductionType(Byte productionType) {
    this.productionType = productionType;
  }

  public String getPhysicalWarehouseCode() {
    return physicalWarehouseCode;
  }

  public void setPhysicalWarehouseCode(String physicalWarehouseCode) {
    this.physicalWarehouseCode = physicalWarehouseCode;
  }

  public String getCityName() {
    return cityName;
  }

  public void setCityName(String cityName) {
    this.cityName = cityName;
  }

  public Integer getTasksQuantity() {
    return tasksQuantity;
  }

  public void setTasksQuantity(Integer tasksQuantity) {
    this.tasksQuantity = tasksQuantity;
  }

  public Integer getCanUseQuantity() {
    if (EmptyUtil.isNotEmpty(canUseQuantity)) {
      return canUseQuantity;
    }
    int soldQuantity = EmptyUtil.isEmpty(this.soldQuantity) ? 0 : this.soldQuantity;
    this.canUseQuantity = this.capacityQuantity - soldQuantity;
    return  this.capacityQuantity - soldQuantity;
  }

  public void setCanUseQuantity(Integer canUseQuantity) {
    this.canUseQuantity = canUseQuantity;
  }

  public Integer getCapacityQuantity() {
    return capacityQuantity;
  }

  public void setCapacityQuantity(Integer capacityQuantity) {
    this.capacityQuantity = capacityQuantity;
  }

  public Integer getSoldQuantity() {
    return soldQuantity;
  }

  public void setSoldQuantity(Integer soldQuantity) {
    this.soldQuantity = soldQuantity;
  }
}
