package com.thebeastshop.stock.dto;

import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;

/**
 * Created by libin.kang on 2017/2/4.
 */
public class SStockReleaseDTO extends SStockOperationDTO {

    protected String referenceCode;
    protected String packageCode;
    protected String businessCode;
    // 预备库存SKU
    protected String preparedSkuCode;
    // 预备库存释放数量
    protected Integer preparedReleaseQuantity;
    // 是否返还到预备库存
    protected Boolean backToPrepared = true;

    public SStockReleaseDTO() {
    }

    public SStockReleaseDTO(SStockOccupyTypeEnum occupyType) {
        this.occupyType = occupyType;
    }


    public String getReferenceCode() {
        if (referenceCode == null && EmptyUtil.isNotEmpty(businessCode)) {
            return businessCode + "_" + preparedSkuCode;
        }
        return referenceCode;
    }


    public void setReferenceCode(String referenceCode) {
        this.referenceCode = referenceCode;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }


    public String getPackageCode() {
        return packageCode;
    }

    public void setPackageCode(String packageCode) {
        this.packageCode = packageCode;
    }

    public String getPreparedSkuCode() {
        return preparedSkuCode;
    }

    public void setPreparedSkuCode(String preparedSkuCode) {
        this.preparedSkuCode = preparedSkuCode;
    }


    public Integer getPreparedReleaseQuantity() {
        return preparedReleaseQuantity;
    }

    public void setPreparedReleaseQuantity(Integer preparedReleaseQuantity) {
        this.preparedReleaseQuantity = preparedReleaseQuantity;
    }

    public Boolean getBackToPrepared() {
        return backToPrepared;
    }

    public void setBackToPrepared(Boolean backToPrepared) {
        this.backToPrepared = backToPrepared;
    }
}