package com.thebeastshop.stock.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;

import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-08-17 18:54
 */
public class SStockOperationDTO extends BaseDO {

    protected SStockOperationTypeEnum operationType;

    protected SStockOccupyTypeEnum occupyType;

    protected List<Integer> occupyTypes;

    protected List<String> warehouseCodes;

    public SStockOperationTypeEnum getOperationType() {
        if (operationType != null) return operationType;
        if (occupyType != null) return occupyType.getReleaseOperationType();
        return null;
    }

    public void setOperationType(SStockOperationTypeEnum operationType) {
        this.operationType = operationType;
    }

    public SStockOccupyTypeEnum getOccupyType() {
        return occupyType;
    }

    public void setOccupyType(SStockOccupyTypeEnum occupyType) {
        this.occupyType = occupyType;
    }

    public List<Integer> getOccupyTypes() {
        return occupyTypes;
    }

    public void setOccupyTypes(List<Integer> occupyTypes) {
        this.occupyTypes = occupyTypes;
    }

    public List<String> getWarehouseCodes() {
        return warehouseCodes;
    }

    public void setWarehouseCodes(List<String> warehouseCodes) {
        this.warehouseCodes = warehouseCodes;
    }
}
