package com.thebeastshop.stock.exception;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.stock.enums.SStockOccupyTypeEnum;
import com.thebeastshop.stock.enums.SStockOperationTypeEnum;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-09-01 16:13
 */
public class SKeyErrorItem extends BaseDO {
    // SKU编号
    private String skuCode;
    // 键值
    private String key;
    // 操作类型
    private SStockOperationTypeEnum operationType;
    // 预备库存业务号
    private String businessCode;
    // 预备库存占用类型
    private SStockOccupyTypeEnum preparedOccupyType;
    // 预备库存逻辑仓号
    private String warehouseCode;
    // 是否有预备库存
    private Boolean hasPreparedStock = false;
    // 错误消息
    private String message;

    public SKeyErrorItem() {
    }

    public SKeyErrorItem(String skuCode, String key, String message) {
        this.skuCode = skuCode;
        this.key = key;
        this.message = message;
    }

    public SKeyErrorItem(String skuCode, String key, SStockOperationTypeEnum operationType, String message) {
        this.skuCode = skuCode;
        this.key = key;
        this.operationType = operationType;
        this.message = message;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getBusinessCode() {
        return businessCode;
    }

    public void setBusinessCode(String businessCode) {
        this.businessCode = businessCode;
    }

    public SStockOccupyTypeEnum getPreparedOccupyType() {
        return preparedOccupyType;
    }

    public void setPreparedOccupyType(SStockOccupyTypeEnum preparedOccupyType) {
        this.preparedOccupyType = preparedOccupyType;
    }

    public String getWarehouseCode() {
        return warehouseCode;
    }

    public void setWarehouseCode(String warehouseCode) {
        this.warehouseCode = warehouseCode;
    }

    public Boolean getHasPreparedStock() {
        return hasPreparedStock;
    }

    public void setHasPreparedStock(Boolean hasPreparedStock) {
        this.hasPreparedStock = hasPreparedStock;
    }

    public SStockOperationTypeEnum getOperationType() {
        return operationType;
    }

    public void setOperationType(SStockOperationTypeEnum operationType) {
        this.operationType = operationType;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}
