package com.thebeastshop.stock.enums;

/**
 * Created by libin.kang on 2017/2/4.
 */
public enum SPresaleStatusEnum {
	STATUS_ENABLE(1,"有效"),
	STATUS_DISABLED(0,"无效"),
	STATUS_WAITSTART(-1,"待启用"),
	STATUS_WAITAUDIT(2,"待审批"),
	STATUS_REJECT(3,"驳回"),
	STATUS_CANCEL(4,"取消")
	
    ;

    private Integer code;

    private String name;

    SPresaleStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName(){
        return name;
    }

    public static SGenderEnum getEnumByCode(Integer code) {
        for (SGenderEnum e : SGenderEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getCode().toString();
    }
}
