/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.web.session;

import com.thebeastshop.common.redis.RedisClient;
import com.thebeastshop.ssoclient.util.SpringContextUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionService {
    private static final Logger log = LoggerFactory.getLogger(SessionService.class);
    private RedisClient redisClient = (RedisClient)SpringContextUtil.getBean("redisClient");
    private Long timeOut = 36000L;

    public Map<String, Object> getSession(String sid) {
        Map<String, Object> session = new HashMap<String, Object>();
        try {
            Object obj = this.redisClient.getCache("s:sds:" + sid);
            if (obj != null) {
                session = (Map)obj;
            }
        }
        catch (Exception e) {
            log.error("Redis\u83b7\u53d6session\u5f02\u5e38:", (Throwable)e);
        }
        return session;
    }

    public void saveSession(String sid, Map<String, Object> session) {
        log.info("saveSession={}", (Object)sid);
        try {
            this.redisClient.putCache("s:sds:" + sid, session, this.timeOut);
        }
        catch (Exception e) {
            log.error("Redis\u4fdd\u5b58session\u5f02\u5e38:", (Throwable)e);
        }
    }

    public void removeSession(String sid) {
        log.info("removeSession={}", (Object)sid);
        try {
            this.redisClient.delCache("s:sds:" + sid);
        }
        catch (Exception e) {
            log.error("Redis\u5220\u9664session\u5f02\u5e38" + e.getMessage(), e.getCause());
        }
    }
}

