/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.web.session;

import com.thebeastshop.ssoclient.web.session.CookieUtil;
import com.thebeastshop.ssoclient.web.session.HttpServletRequestWrapper;
import com.thebeastshop.ssoclient.web.session.SessionService;
import com.thebeastshop.ssoclient.web.session.StringUtils;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class SessionFilter
extends OncePerRequestFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(SessionService.class);

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String strUrl;
        String sid = CookieUtil.getCookieValue(request, "YHMJSESSIONID");
        if (StringUtils.isEmpty(sid) || sid.length() != 36) {
            if (StringUtils.isEmpty(sid)) {
                log.info("sid is null");
            } else if (sid.length() != 36) {
                log.info("sid.length is is ={}", (Object)sid.length());
            }
            sid = StringUtils.getUuid();
            log.info("new sid={}", (Object)sid);
            CookieUtil.setCookie(request, response, "YHMJSESSIONID", sid, -1);
        }
        if ((strUrl = request.getRequestURI()).endsWith(".js") || strUrl.endsWith(".css") || strUrl.endsWith(".png") || strUrl.endsWith(".jpg") || strUrl.endsWith(".jpeg") || strUrl.endsWith(".ico")) {
            log.info("session\u4e0d\u5904\u7406={}", (Object)strUrl);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        log.info("session\u5904\u7406={}", (Object)request.getRequestURI());
        filterChain.doFilter((ServletRequest)new HttpServletRequestWrapper(sid, request, response), (ServletResponse)response);
    }
}

