/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.web.session;

import com.thebeastshop.ssoclient.web.session.CookieUtil;
import com.thebeastshop.ssoclient.web.session.Enumerator;
import com.thebeastshop.ssoclient.web.session.SessionService;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpSessionWrapper
implements HttpSession {
    private static final Logger log = LoggerFactory.getLogger(HttpSessionWrapper.class);
    private String sid = "";
    private HttpSession session;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Map<String, Object> map = null;
    private SessionService sessionService = new SessionService();

    public HttpSessionWrapper() {
    }

    public HttpSessionWrapper(HttpSession session) {
        this.session = session;
    }

    public HttpSessionWrapper(String sid, HttpSession session) {
        this(session);
        this.sid = sid;
    }

    public HttpSessionWrapper(String sid, HttpSession session, HttpServletRequest request, HttpServletResponse response) {
        this(sid, session);
        this.request = request;
        this.response = response;
    }

    private Map<String, Object> getSessionMap() {
        if (this.map == null) {
            this.map = this.sessionService.getSession(this.sid);
        }
        return this.map;
    }

    public Object getAttribute(String name) {
        if (this.getSessionMap() != null) {
            Object value = this.getSessionMap().get(name);
            return value;
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        this.getSessionMap().put(name, value);
        this.sessionService.saveSession(this.sid, this.getSessionMap());
    }

    public void invalidate() {
        this.getSessionMap().clear();
        this.sessionService.removeSession(this.sid);
        CookieUtil.removeCookieValue(this.request, this.response, "YHMJSESSIONID");
    }

    public void removeAttribute(String name) {
        this.getSessionMap().remove(name);
        this.sessionService.saveSession(this.sid, this.getSessionMap());
    }

    public Object getValue(String name) {
        return this.session.getValue(name);
    }

    public Enumeration getAttributeNames() {
        return new Enumerator<String>(this.getSessionMap().keySet(), true);
    }

    public String[] getValueNames() {
        return this.session.getValueNames();
    }

    public void putValue(String name, Object value) {
        this.session.putValue(name, value);
    }

    public void removeValue(String name) {
        this.session.removeValue(name);
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.sid;
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public ServletContext getServletContext() {
        return this.session.getServletContext();
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public HttpSessionContext getSessionContext() {
        return this.session.getSessionContext();
    }

    public boolean isNew() {
        return this.session.isNew();
    }
}

