/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.validation;

import com.thebeastshop.ssoclient.cas.util.XmlUtils;
import com.thebeastshop.ssoclient.cas.validation.Assertion;
import com.thebeastshop.ssoclient.cas.validation.Cas20ServiceTicketValidator;
import com.thebeastshop.ssoclient.cas.validation.InvalidProxyChainTicketValidationException;
import com.thebeastshop.ssoclient.cas.validation.ProxyList;
import com.thebeastshop.ssoclient.cas.validation.TicketValidationException;
import java.util.List;

public class Cas20ProxyTicketValidator
extends Cas20ServiceTicketValidator {
    private boolean acceptAnyProxy;
    private ProxyList allowedProxyChains = new ProxyList();

    public Cas20ProxyTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
    }

    public ProxyList getAllowedProxyChains() {
        return this.allowedProxyChains;
    }

    protected String getUrlSuffix() {
        return "proxyValidate";
    }

    protected void customParseResponse(String response, Assertion assertion) throws TicketValidationException {
        List proxies = XmlUtils.getTextForElements(response, "proxy");
        String[] proxiedList = proxies.toArray(new String[proxies.size()]);
        if (proxies == null || proxies.isEmpty() || this.acceptAnyProxy) {
            return;
        }
        if (this.allowedProxyChains.contains(proxiedList)) {
            return;
        }
        throw new InvalidProxyChainTicketValidationException("Invalid proxy chain: " + proxies.toString());
    }

    public void setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public void setAllowedProxyChains(ProxyList allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }
}

