/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.validation;

import com.thebeastshop.ssoclient.cas.proxy.Cas20ProxyRetriever;
import com.thebeastshop.ssoclient.cas.proxy.CleanUpTimerTask;
import com.thebeastshop.ssoclient.cas.proxy.ProxyGrantingTicketStorage;
import com.thebeastshop.ssoclient.cas.proxy.ProxyGrantingTicketStorageImpl;
import com.thebeastshop.ssoclient.cas.util.CommonUtils;
import com.thebeastshop.ssoclient.cas.validation.AbstractTicketValidationFilter;
import com.thebeastshop.ssoclient.cas.validation.Cas20ProxyTicketValidator;
import com.thebeastshop.ssoclient.cas.validation.Cas20ServiceTicketValidator;
import com.thebeastshop.ssoclient.cas.validation.TicketValidator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Cas20ProxyReceivingTicketValidationFilter
extends AbstractTicketValidationFilter {
    private static final String[] RESERVED_INIT_PARAMS = new String[]{"proxyGrantingTicketStorageClass", "proxyReceptorUrl", "acceptAnyProxy", "allowedProxyChains", "casServerUrlPrefix", "proxyCallbackUrl", "renew", "exceptionOnValidationFailure", "redirectAfterValidation", "useSession", "serverName", "service", "artifactParameterName", "serviceParameterName", "encodeServiceUrl", "millisBetweenCleanUps"};
    private static final int DEFAULT_MILLIS_BETWEEN_CLEANUPS = 60000;
    private String proxyReceptorUrl;
    private Timer timer;
    private TimerTask timerTask;
    private int millisBetweenCleanUps;
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage = new ProxyGrantingTicketStorageImpl();

    @Override
    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        this.setProxyReceptorUrl(this.getPropertyFromInitParams(filterConfig, "proxyReceptorUrl", null));
        String proxyGrantingTicketStorageClass = this.getPropertyFromInitParams(filterConfig, "proxyGrantingTicketStorageClass", null);
        if (proxyGrantingTicketStorageClass != null) {
            try {
                Class<?> storageClass = Class.forName(proxyGrantingTicketStorageClass);
                this.proxyGrantingTicketStorage = (ProxyGrantingTicketStorage)storageClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.log.trace((Object)("Setting proxyReceptorUrl parameter: " + this.proxyReceptorUrl));
        this.millisBetweenCleanUps = Integer.parseInt(this.getPropertyFromInitParams(filterConfig, "millisBetweenCleanUps", Integer.toString(60000)));
        super.initInternal(filterConfig);
    }

    @Override
    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.proxyGrantingTicketStorage, "proxyGrantingTicketStorage cannot be null.");
        if (this.timer == null) {
            this.timer = new Timer(true);
        }
        if (this.timerTask == null) {
            this.timerTask = new CleanUpTimerTask(this.proxyGrantingTicketStorage);
        }
        this.timer.schedule(this.timerTask, this.millisBetweenCleanUps, (long)this.millisBetweenCleanUps);
    }

    @Override
    protected final TicketValidator getTicketValidator(FilterConfig filterConfig) {
        Cas20ServiceTicketValidator validator;
        String allowAnyProxy = this.getPropertyFromInitParams(filterConfig, "acceptAnyProxy", null);
        String allowedProxyChains = this.getPropertyFromInitParams(filterConfig, "allowedProxyChains", null);
        String casServerUrlPrefix = this.getPropertyFromInitParams(filterConfig, "casServerUrlPrefix", null);
        if (CommonUtils.isNotBlank(allowAnyProxy) || CommonUtils.isNotBlank(allowedProxyChains)) {
            Cas20ProxyTicketValidator v = new Cas20ProxyTicketValidator(casServerUrlPrefix);
            v.setAcceptAnyProxy(this.parseBoolean(allowAnyProxy));
            v.setAllowedProxyChains(CommonUtils.createProxyList(allowedProxyChains));
            validator = v;
        } else {
            validator = new Cas20ServiceTicketValidator(casServerUrlPrefix);
        }
        validator.setProxyCallbackUrl(this.getPropertyFromInitParams(filterConfig, "proxyCallbackUrl", null));
        validator.setProxyGrantingTicketStorage(this.proxyGrantingTicketStorage);
        validator.setProxyRetriever(new Cas20ProxyRetriever(casServerUrlPrefix, this.getPropertyFromInitParams(filterConfig, "encoding", null)));
        validator.setRenew(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "renew", "false")));
        validator.setEncoding(this.getPropertyFromInitParams(filterConfig, "encoding", null));
        HashMap<String, String> additionalParameters = new HashMap<String, String>();
        List<String> params = Arrays.asList(RESERVED_INIT_PARAMS);
        Enumeration e = filterConfig.getInitParameterNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (params.contains(s)) continue;
            additionalParameters.put(s, filterConfig.getInitParameter(s));
        }
        validator.setCustomParameters(additionalParameters);
        validator.setHostnameVerifier(this.getHostnameVerifier(filterConfig));
        return validator;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.timer.cancel();
    }

    @Override
    protected final boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String requestUri = request.getRequestURI();
        if (CommonUtils.isEmpty(this.proxyReceptorUrl) || !requestUri.endsWith(this.proxyReceptorUrl)) {
            return true;
        }
        try {
            CommonUtils.readAndRespondToProxyReceptorRequest(request, response, this.proxyGrantingTicketStorage);
        }
        catch (RuntimeException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        return false;
    }

    public final void setProxyReceptorUrl(String proxyReceptorUrl) {
        this.proxyReceptorUrl = proxyReceptorUrl;
    }

    public void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage storage) {
        this.proxyGrantingTicketStorage = storage;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setTimerTask(TimerTask timerTask) {
        this.timerTask = timerTask;
    }

    public void setMillisBetweenCleanUps(int millisBetweenCleanUps) {
        this.millisBetweenCleanUps = millisBetweenCleanUps;
    }
}

