/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.session;

import com.thebeastshop.common.redis.RedisClient;
import com.thebeastshop.ssoclient.cas.session.SessionMappingStorage;
import com.thebeastshop.ssoclient.util.SpringContextUtil;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisBackedSessionMappingStorage
implements SessionMappingStorage {
    private static final Logger log = LoggerFactory.getLogger(RedisBackedSessionMappingStorage.class);
    private RedisClient redisClient = (RedisClient)SpringContextUtil.getBean("redisClient");
    public static final String token_session_relation = "tsr:";

    @Override
    public void addSessionById(String mappingId, HttpSession session) {
        String cacheTokenId = token_session_relation + mappingId;
        log.info("mappingId={},session.id={}", (Object)cacheTokenId, (Object)session.getId());
        this.redisClient.putCache(cacheTokenId, (Object)session.getId());
    }

    @Override
    public void removeBySessionById(String sessionId) {
    }

    @Override
    public HttpSession removeSessionByMappingId(String mappingId) {
        String cacheTokenId = token_session_relation + mappingId;
        log.info("removeSessionByMappingId={}", (Object)cacheTokenId);
        String sessionId = (String)this.redisClient.getCache(cacheTokenId);
        if (sessionId == null) {
            log.info("cacheTokenId={} is null", (Object)cacheTokenId);
            return null;
        }
        String cacheSessionId = "s:ds:" + sessionId;
        log.info("cacheSessionId={}", (Object)cacheSessionId);
        boolean result = this.redisClient.delCache(cacheSessionId);
        if (result) {
            log.info("delete success={}", (Object)cacheSessionId);
        } else {
            log.info("delete failed={}", (Object)cacheSessionId);
        }
        return null;
    }
}

