/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.proxy;

import com.thebeastshop.ssoclient.cas.proxy.ProxyRetriever;
import com.thebeastshop.ssoclient.cas.util.CommonUtils;
import com.thebeastshop.ssoclient.cas.util.XmlUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Cas20ProxyRetriever
implements ProxyRetriever {
    private static final long serialVersionUID = 560409469568911791L;
    private final Log log = LogFactory.getLog(this.getClass());
    private final String casServerUrl;
    private final String encoding;

    public Cas20ProxyRetriever(String casServerUrl, String encoding) {
        CommonUtils.assertNotNull(casServerUrl, "casServerUrl cannot be null.");
        this.casServerUrl = casServerUrl;
        this.encoding = encoding;
    }

    @Override
    public String getProxyTicketIdFor(String proxyGrantingTicketId, String targetService) {
        String url = this.constructUrl(proxyGrantingTicketId, targetService);
        String response = CommonUtils.getResponseFromServer(url, this.encoding);
        String error = XmlUtils.getTextForElement(response, "proxyFailure");
        if (CommonUtils.isNotEmpty(error)) {
            this.log.debug((Object)error);
            return null;
        }
        return XmlUtils.getTextForElement(response, "proxyTicket");
    }

    private String constructUrl(String proxyGrantingTicketId, String targetService) {
        try {
            return this.casServerUrl + (this.casServerUrl.endsWith("/") ? "" : "/") + "proxy" + "?pgt=" + proxyGrantingTicketId + "&targetService=" + URLEncoder.encode(targetService, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

