/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.web.session;

import com.thebeastshop.common.redis.RedisClient;
import com.thebeastshop.ssoclient.util.SpringContextUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionService {
    private static final Logger log = LoggerFactory.getLogger(SessionService.class);
    private RedisClient redisClient = (RedisClient)SpringContextUtil.getBean("redisClient");
    private Long timeOut = 604800L;

    public Map<String, Object> getSession(String sid) {
        Map<String, Object> session = new HashMap<String, Object>();
        try {
            Object obj = this.redisClient.getCache("s:ds:" + sid);
            if (obj != null) {
                session = (Map)obj;
            }
        }
        catch (Exception e) {
            log.error("Redis\u83b7\u53d6session\u5f02\u5e38:", (Throwable)e);
        }
        return session;
    }

    public void saveSession(String sid, Map<String, Object> session) {
        log.info("saveSession={}", (Object)sid);
        try {
            this.redisClient.putCache("s:ds:" + sid, session, this.timeOut);
        }
        catch (Exception e) {
            log.error("Redis\u4fdd\u5b58session\u5f02\u5e38:", (Throwable)e);
        }
    }

    public void removeSession(String sid) {
        log.info("removeSession={}", (Object)sid);
        try {
            this.redisClient.delCache("s:ds:" + sid);
        }
        catch (Exception e) {
            log.error("Redis\u5220\u9664session\u5f02\u5e38" + e.getMessage(), e.getCause());
        }
    }
}

