/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.validation;

import com.thebeastshop.ssoclient.cas.util.AbstractCasFilter;
import com.thebeastshop.ssoclient.cas.util.CommonUtils;
import com.thebeastshop.ssoclient.cas.validation.Assertion;
import com.thebeastshop.ssoclient.cas.validation.TicketValidationException;
import com.thebeastshop.ssoclient.cas.validation.TicketValidator;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.net.ssl.HostnameVerifier;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractTicketValidationFilter
extends AbstractCasFilter {
    private TicketValidator ticketValidator;
    private boolean redirectAfterValidation = false;
    private boolean exceptionOnValidationFailure = true;
    private boolean useSession = true;

    protected TicketValidator getTicketValidator(FilterConfig filterConfig) {
        return this.ticketValidator;
    }

    protected HostnameVerifier getHostnameVerifier(FilterConfig filterConfig) {
        String className = this.getPropertyFromInitParams(filterConfig, "hostnameVerifier", null);
        this.log.trace((Object)("Using hostnameVerifier parameter: " + className));
        String config = this.getPropertyFromInitParams(filterConfig, "hostnameVerifierConfig", null);
        this.log.trace((Object)("Using hostnameVerifierConfig parameter: " + config));
        HostnameVerifier verifier = null;
        if (className != null) {
            try {
                Class<?> verifierClass = Class.forName(className);
                if (config != null) {
                    Constructor<?> cons = verifierClass.getConstructor(String.class);
                    verifier = (HostnameVerifier)cons.newInstance(config);
                } else {
                    verifier = (HostnameVerifier)verifierClass.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Invalid HostnameVerifier class " + className);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error creating instance of " + className, e);
            }
        }
        return verifier;
    }

    @Override
    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        this.setExceptionOnValidationFailure(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "exceptionOnValidationFailure", "true")));
        this.log.trace((Object)("Setting exceptionOnValidationFailure parameter: " + this.exceptionOnValidationFailure));
        this.setRedirectAfterValidation(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "redirectAfterValidation", "true")));
        this.log.trace((Object)("Setting redirectAfterValidation parameter: " + this.redirectAfterValidation));
        this.setUseSession(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "useSession", "true")));
        this.log.trace((Object)("Setting useSession parameter: " + this.useSession));
        this.setTicketValidator(this.getTicketValidator(filterConfig));
        super.initInternal(filterConfig);
    }

    @Override
    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.ticketValidator, "ticketValidator cannot be null.");
    }

    protected boolean preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        return true;
    }

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
    }

    protected void onFailedValidation(HttpServletRequest request, HttpServletResponse response) {
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.log.info((Object)"doFilter=");
        if (!this.preFilter(servletRequest, servletResponse, filterChain)) {
            this.log.info((Object)"preFilter=");
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String ticket = CommonUtils.safeGetParameter(request, this.getArtifactParameterName());
        this.log.info((Object)("ticket=" + ticket));
        if (CommonUtils.isNotBlank(ticket)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Attempting to validate ticket: " + ticket));
            }
            try {
                Assertion assertion = this.ticketValidator.validate(ticket, this.constructServiceUrl(request, response));
                this.log.info((Object)("assertion.Date" + assertion.toString()));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Successfully authenticated user: " + assertion.getPrincipal().getName()));
                }
                request.setAttribute("_const_cas_assertion_", (Object)assertion);
                if (this.useSession) {
                    this.log.info((Object)"is useSession");
                    request.getSession().setAttribute("_const_cas_assertion_", (Object)assertion);
                }
                this.onSuccessfulValidation(request, response, assertion);
                if (this.redirectAfterValidation) {
                    this.log.debug((Object)"Redirecting after successful ticket validation.");
                    response.sendRedirect(this.constructServiceUrl(request, response));
                    return;
                }
            }
            catch (TicketValidationException e) {
                response.setStatus(403);
                this.log.warn((Object)e, (Throwable)e);
                this.onFailedValidation(request, response);
                if (this.exceptionOnValidationFailure) {
                    throw new ServletException((Throwable)e);
                }
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public final void setTicketValidator(TicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    public final void setRedirectAfterValidation(boolean redirectAfterValidation) {
        this.redirectAfterValidation = redirectAfterValidation;
    }

    public final void setExceptionOnValidationFailure(boolean exceptionOnValidationFailure) {
        this.exceptionOnValidationFailure = exceptionOnValidationFailure;
    }

    public final void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }
}

