/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.ssoclient.cas.authentication;

import com.thebeastshop.ssoclient.cas.authentication.DefaultGatewayResolverImpl;
import com.thebeastshop.ssoclient.cas.authentication.GatewayResolver;
import com.thebeastshop.ssoclient.cas.util.AbstractCasFilter;
import com.thebeastshop.ssoclient.cas.util.CommonUtils;
import com.thebeastshop.ssoclient.cas.validation.Assertion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthenticationFilter
extends AbstractCasFilter {
    private String casServerLoginUrl;
    private String serverName;
    private boolean renew = false;
    private boolean gateway = false;
    private List<String> anonUrlList = new ArrayList<String>();
    private List<String> anonPatternUrlList = new ArrayList<String>();
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();

    @Override
    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        if (!this.isIgnoreInitConfiguration()) {
            String gatewayStorageClass;
            super.initInternal(filterConfig);
            this.setCasServerLoginUrl(this.getPropertyFromInitParams(filterConfig, "casServerLoginUrl", null));
            this.log.trace((Object)("Loaded CasServerLoginUrl parameter: " + this.casServerLoginUrl));
            this.serverName = this.getPropertyFromInitParams(filterConfig, "serverName", null);
            this.setRenew(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "renew", "false")));
            this.log.trace((Object)("Loaded renew parameter: " + this.renew));
            this.setGateway(this.parseBoolean(this.getPropertyFromInitParams(filterConfig, "gateway", "false")));
            this.log.trace((Object)("Loaded gateway parameter: " + this.gateway));
            String strAnonUrlList = this.getPropertyFromInitParams(filterConfig, "anonUrlList", "");
            if (strAnonUrlList == null) {
                strAnonUrlList = "";
            }
            strAnonUrlList = strAnonUrlList.trim();
            this.log.info((Object)("anonUrlList text length=" + strAnonUrlList.length()));
            if (strAnonUrlList.length() > 0) {
                String[] strArray;
                for (String arrayItem : strArray = strAnonUrlList.split(",")) {
                    if (arrayItem == null || (arrayItem = arrayItem.trim()).length() <= 0) continue;
                    if (arrayItem.endsWith("**")) {
                        String urlPattern = arrayItem.substring(0, arrayItem.length() - 2);
                        this.log.info((Object)("annon urlPattern=" + urlPattern + ",length=" + urlPattern.length()));
                        this.anonPatternUrlList.add(urlPattern);
                        continue;
                    }
                    this.log.info((Object)("annon url=" + arrayItem + ",length=" + arrayItem.length()));
                    this.anonUrlList.add(arrayItem);
                }
                this.log.info((Object)("anonPatternUrlList size()=" + this.anonPatternUrlList.size()));
                this.log.info((Object)("anonUrlList size()=" + this.anonUrlList.size()));
            }
            if ((gatewayStorageClass = this.getPropertyFromInitParams(filterConfig, "gatewayStorageClass", null)) != null) {
                try {
                    this.gatewayStorage = (GatewayResolver)Class.forName(gatewayStorageClass).newInstance();
                }
                catch (Exception e) {
                    this.log.error((Object)e, (Throwable)e);
                    throw new ServletException((Throwable)e);
                }
            }
        }
    }

    @Override
    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.casServerLoginUrl, "casServerLoginUrl cannot be null.");
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String modifiedServiceUrl;
        Assertion assertion;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession(false);
        Assertion assertion2 = assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
        if (assertion != null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String requestStr = request.getRequestURI();
        this.log.info((Object)("\u9a8c\u8bc1url=" + requestStr));
        if (this.anonUrlList.contains(requestStr)) {
            this.log.info((Object)("anon \u653e\u884c=" + requestStr));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        for (String strPatter : this.anonPatternUrlList) {
            if (!requestStr.startsWith(strPatter)) continue;
            this.log.info((Object)("anon* \u653e\u884c=" + requestStr));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String oldUrl = this.constructServiceUrl(request, response);
        this.log.info((Object)("oldUrl=" + oldUrl));
        if (this.serverName != null && this.serverName.length() > 0) {
            oldUrl = this.serverName;
            this.log.info((Object)("serverName=" + this.serverName));
        }
        String serviceUrl = oldUrl;
        String ticket = CommonUtils.safeGetParameter(request, this.getArtifactParameterName());
        boolean wasGatewayed = this.gatewayStorage.hasGatewayedAlready(request, serviceUrl);
        if (CommonUtils.isNotBlank(ticket) || wasGatewayed) {
            this.log.info((Object)("\u5df2\u9a8c\u8bc1,ticket=" + ticket + ",wasGatewayed=" + wasGatewayed));
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.log.debug((Object)"no ticket and no assertion found");
        if (this.gateway) {
            this.log.debug((Object)"setting gateway attribute in session");
            modifiedServiceUrl = this.gatewayStorage.storeGatewayInformation(request, serviceUrl);
        } else {
            modifiedServiceUrl = serviceUrl;
        }
        this.log.info((Object)("modifiedServiceUrl=" + modifiedServiceUrl));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Constructed service url: " + modifiedServiceUrl));
        }
        String urlToRedirectTo = CommonUtils.constructRedirectUrl(this.casServerLoginUrl, this.getServiceParameterName(), modifiedServiceUrl, this.renew, this.gateway);
        this.log.info((Object)("urlToRedirectTo=" + urlToRedirectTo));
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("redirecting to \"" + urlToRedirectTo + "\""));
        }
        try {
            response.sendRedirect(urlToRedirectTo);
        }
        catch (Exception e) {
            this.log.error((Object)"sendRedirect \u5f02\u5e38:", (Throwable)e);
        }
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public final void setGatewayStorage(GatewayResolver gatewayStorage) {
        this.gatewayStorage = gatewayStorage;
    }
}

