/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.share.order.dto.shareOrder;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.common.BaseDO;
import com.thebeastshop.share.order.dto.shareOrder.Image;
import com.thebeastshop.share.order.dto.shareOrder.Video;
import com.thebeastshop.share.order.enums.shareOrder.MediaAnnexEnum;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MediaAnnex
extends BaseDO {
    private MediaAnnexEnum type;
    private List<Image> images;
    private Video video;

    public String buildShareImage() {
        String imageSrc = "";
        if (MediaAnnexEnum.IMAGE.equals((Object)this.type) && CollectionUtils.isNotEmpty(this.images)) {
            imageSrc = this.images.get(0).getSrc();
        }
        if (MediaAnnexEnum.VIDEO.equals((Object)this.type) && null != this.video && null != this.video.getCoverImage()) {
            imageSrc = this.video.getCoverImage().getSrc();
        }
        return imageSrc;
    }

    public static MediaAnnex Builder(MediaAnnexEnum type, String annexContent) {
        MediaAnnex articleAnnex = new MediaAnnex();
        if (null == type) {
            return null;
        }
        articleAnnex.setType(type);
        try {
            if (StringUtils.isNotEmpty((CharSequence)annexContent)) {
                switch (type) {
                    case IMAGE: {
                        articleAnnex.setImages(JSONObject.parseArray((String)annexContent, Image.class));
                        break;
                    }
                    case VIDEO: {
                        articleAnnex.setVideo((Video)((Object)JSONObject.parseObject((String)annexContent, Video.class)));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return articleAnnex;
    }

    public MediaAnnexEnum getType() {
        return this.type;
    }

    public void setType(MediaAnnexEnum type) {
        this.type = type;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public void setImages(List<Image> images) {
        this.images = images;
    }

    public Video getVideo() {
        return this.video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }
}

