/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.sensors;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.thebeastshop.common.zk.ZkDriver;
import com.thebeastshop.common.zk.ZkListener;
import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import com.thebeastshop.sensors.BeastSensorsProperty;
import com.thebeastshop.sensors.core.BeastSensorsClient;
import com.thebeastshop.sensors.core.BeastYoushuClient;
import com.thebeastshop.sensors.exceptions.KafkaAddressNotConfigInZkException;
import com.thebeastshop.sensors.exceptions.ZkAddressNotConfigException;
import com.thebeastshop.sensors.exceptions.ZkNodeNotExistException;
import com.thebeastshop.sensors.vo.ZkMetaVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class BeastTrackerInit
implements InitializingBean {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private BeastSensorsProperty beastSensorsProperty;
    private BeastSensorsClient beastSensorsClient;
    private BeastYoushuClient beastYoushuClient;

    public void afterPropertiesSet() throws Exception {
        if (StrUtil.isBlank((CharSequence)this.beastSensorsProperty.getZkAddress())) {
            throw new ZkAddressNotConfigException("[beast-sensors] please config zk-address first");
        }
        ZkDriver zkDriver = ZkDriver.drive((String)this.beastSensorsProperty.getZkAddress());
        if (!zkDriver.checkExist("/sensors/kafka_address")) {
            throw new ZkNodeNotExistException(StrUtil.format((CharSequence)"[beast-sensors] zk node [{}] is not exist", (Object[])new Object[]{"/sensors/kafka_address"}));
        }
        ZkMetaVO zkMeta = (ZkMetaVO)zkDriver.getNodeData("/sensors/kafka_address", ZkMetaVO.class);
        if (StrUtil.isBlank((CharSequence)zkMeta.getKafkaAddress())) {
            throw new KafkaAddressNotConfigInZkException("[beast-sensors] the kafka address is blank in zk");
        }
        this.log.info("[beast-sensors]\u83b7\u53d6\u5230\u7684kafka\u8fde\u63a5\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)zkMeta));
        KafkaDriver kafkaDriver = KafkaDriver.drive((String)zkMeta.getKafkaAddress());
        this.beastSensorsClient.setKafkaDriver(kafkaDriver);
        this.beastSensorsClient.setEnable(this.beastSensorsProperty.isEnable());
        this.beastYoushuClient.setKafkaDriver(kafkaDriver);
        this.beastYoushuClient.setEnable(this.beastSensorsProperty.isEnable());
        zkDriver.createListener("/sensors/kafka_address", (ZkListener)new ZkListener<ZkMetaVO>(){

            public void dataChanged(ZkMetaVO data) {
                KafkaDriver driver = KafkaDriver.reDrive((String)data.getKafkaAddress());
                BeastTrackerInit.this.beastSensorsClient.setKafkaDriver(driver);
                BeastTrackerInit.this.beastYoushuClient.setKafkaDriver(driver);
            }
        }, false);
    }

    public BeastSensorsProperty getBeastSensorsProperty() {
        return this.beastSensorsProperty;
    }

    public void setBeastSensorsProperty(BeastSensorsProperty beastSensorsProperty) {
        this.beastSensorsProperty = beastSensorsProperty;
    }

    public BeastSensorsClient getBeastSensorsClient() {
        return this.beastSensorsClient;
    }

    public void setBeastSensorsClient(BeastSensorsClient beastSensorsClient) {
        this.beastSensorsClient = beastSensorsClient;
    }

    public BeastYoushuClient getBeastYoushuClient() {
        return this.beastYoushuClient;
    }

    public void setBeastYoushuClient(BeastYoushuClient beastYoushuClient) {
        this.beastYoushuClient = beastYoushuClient;
    }
}

