/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.sensors.core;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import com.thebeastshop.sensors.enums.GetTypeEnum;
import com.thebeastshop.sensors.enums.TrackTypeEnum;
import com.thebeastshop.sensors.vo.CancelOrderDetailVO;
import com.thebeastshop.sensors.vo.CancelOrderVO;
import com.thebeastshop.sensors.vo.CodeGetTrackVO;
import com.thebeastshop.sensors.vo.CommonVO;
import com.thebeastshop.sensors.vo.FinishOrderVO;
import com.thebeastshop.sensors.vo.MPAuthTrackVO;
import com.thebeastshop.sensors.vo.MpHelperSuccessTrackVO;
import com.thebeastshop.sensors.vo.MpHelperTrackVO;
import com.thebeastshop.sensors.vo.PayOrderTrackVO;
import com.thebeastshop.sensors.vo.RegisterOrLoginTrackVO;
import com.thebeastshop.sensors.vo.SearchTrackVO;
import com.thebeastshop.sensors.vo.SubmitOrderVO;
import com.thebeastshop.sensors.vo.TrackDataVO;
import java.util.Collection;
import java.util.List;

public class BeastSensorsClient {
    private KafkaDriver kafkaDriver;

    public void register(RegisterOrLoginTrackVO trackVO) {
        trackVO.setGetType(GetTypeEnum.REGISTER);
        this.send(TrackTypeEnum.REGISTER_OR_LOGIN, trackVO);
    }

    public void login(RegisterOrLoginTrackVO trackVO) {
        trackVO.setGetType(GetTypeEnum.LOGIN);
        this.send(TrackTypeEnum.REGISTER_OR_LOGIN, trackVO);
    }

    public void submitOrder(SubmitOrderVO submitOrderVO) {
        this.send(TrackTypeEnum.SUBMIT_ORDER, submitOrderVO);
    }

    public void cancelOrder(CancelOrderVO cancelOrderVO) {
        this.send(TrackTypeEnum.CANCEL_ORDER, cancelOrderVO);
    }

    public void cancelPartOrder(CancelOrderVO cancelOrderVO) {
        this.send(TrackTypeEnum.CANCEL_PART_ORDER, cancelOrderVO);
    }

    public void cancelPartOrderDetail(List<CancelOrderDetailVO> cancelOrderDetailVOs) {
        this.send(TrackTypeEnum.CANCEL_PART_ORDER_SKU, cancelOrderDetailVOs);
    }

    public void finishOrder(FinishOrderVO finishOrderVO) {
        this.send(TrackTypeEnum.FINISH_ORDER, finishOrderVO);
    }

    public void getCodeResult(CodeGetTrackVO codeGetTrackVO) {
        this.send(TrackTypeEnum.CODE_GET, codeGetTrackVO);
    }

    public void search(SearchTrackVO searchTrackVO) {
        this.send(TrackTypeEnum.SEARCH, searchTrackVO);
    }

    public void payOrder(PayOrderTrackVO payOrderTrackVO) {
        this.send(TrackTypeEnum.PAY_ORDER, payOrderTrackVO);
    }

    public void mpHelp(MpHelperTrackVO mpHelperTrackVO) {
        this.send(TrackTypeEnum.MP_HELP, mpHelperTrackVO);
    }

    public void mpHelpSuccess(MpHelperSuccessTrackVO mpHelperSuccessTrackVO) {
        this.send(TrackTypeEnum.MP_HELP_SUCCESS, mpHelperSuccessTrackVO);
    }

    public void mpAuth(MPAuthTrackVO mpAuthTrackVO) {
        this.send(TrackTypeEnum.MP_AUTH, mpAuthTrackVO);
    }

    public KafkaDriver getKafkaDriver() {
        return this.kafkaDriver;
    }

    public void setKafkaDriver(KafkaDriver kafkaDriver) {
        this.kafkaDriver = kafkaDriver;
    }

    private <T extends CommonVO> void send(TrackDataVO<T> trackDataVO) {
        this.kafkaDriver.send((Object)JSON.toJSONString(trackDataVO));
    }

    private <T extends CommonVO> void send(TrackTypeEnum trackType, T data) {
        this.send(new TrackDataVO(trackType, data));
    }

    private <T extends Collection<R>, R extends CommonVO> void send(TrackTypeEnum trackType, T data) {
        this.kafkaDriver.send((Object)JSON.toJSONString((Object)new TrackDataVO(trackType, data)));
    }
}

