/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.sensors;

import cn.hutool.core.util.StrUtil;
import com.thebeastshop.common.zk.ZkDriver;
import com.thebeastshop.common.zk.ZkListener;
import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import com.thebeastshop.sensors.BeastSensorsProperty;
import com.thebeastshop.sensors.core.BeastSensorsClient;
import com.thebeastshop.sensors.exceptions.KafkaAddressNotConfigInZkException;
import com.thebeastshop.sensors.exceptions.KafkaTopicNotConfigException;
import com.thebeastshop.sensors.exceptions.ZkAddressNotConfigException;
import com.thebeastshop.sensors.exceptions.ZkNodeNotExistException;
import com.thebeastshop.sensors.vo.ZkMetaVO;
import org.springframework.beans.factory.InitializingBean;

public class BeastSensorsInit
implements InitializingBean {
    private BeastSensorsProperty beastSensorsProperty;
    private BeastSensorsClient beastSensorsClient;

    public void afterPropertiesSet() throws Exception {
        if (StrUtil.isBlank((CharSequence)this.beastSensorsProperty.getZkAddress())) {
            throw new ZkAddressNotConfigException("[beast-sensors] please config zk-address first");
        }
        ZkDriver zkDriver = ZkDriver.drive((String)this.beastSensorsProperty.getZkAddress());
        if (!zkDriver.checkExist("/sensors/kafka_address")) {
            throw new ZkNodeNotExistException(StrUtil.format((CharSequence)"[beast-sensors] zk node [{}] is not exist", (Object[])new Object[]{"/sensors/kafka_address"}));
        }
        ZkMetaVO zkMeta = (ZkMetaVO)zkDriver.getNodeData("/sensors/kafka_address", ZkMetaVO.class);
        if (StrUtil.isBlank((CharSequence)zkMeta.getKafkaAddress())) {
            throw new KafkaAddressNotConfigInZkException("[beast-sensors] the kafka address is blank in zk");
        }
        KafkaDriver kafkaDriver = KafkaDriver.drive((String)zkMeta.getKafkaAddress());
        if (StrUtil.isBlank((CharSequence)zkMeta.getTopic())) {
            throw new KafkaTopicNotConfigException("[beast-sensors] please config topic first");
        }
        kafkaDriver.setDefaultTopic(zkMeta.getTopic());
        this.beastSensorsClient.setKafkaDriver(kafkaDriver);
        zkDriver.createListener("/sensors/kafka_address", (ZkListener)new ZkListener<ZkMetaVO>(){

            public void dataChanged(ZkMetaVO data) {
                KafkaDriver driver = KafkaDriver.reDrive((String)data.getKafkaAddress());
                driver.setDefaultTopic(data.getTopic());
                BeastSensorsInit.this.beastSensorsClient.setKafkaDriver(driver);
            }
        }, false);
    }

    public BeastSensorsProperty getBeastSensorsProperty() {
        return this.beastSensorsProperty;
    }

    public void setBeastSensorsProperty(BeastSensorsProperty beastSensorsProperty) {
        this.beastSensorsProperty = beastSensorsProperty;
    }

    public BeastSensorsClient getBeastSensorsClient() {
        return this.beastSensorsClient;
    }

    public void setBeastSensorsClient(BeastSensorsClient beastSensorsClient) {
        this.beastSensorsClient = beastSensorsClient;
    }
}

