package com.thebeastshop.salesorder.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.salesorder.dto.wechatGift.SoWechatGiftQueryDto;
import com.thebeastshop.salesorder.dto.wechatGift.SoWechatGiftReceiveDto;
import com.thebeastshop.salesorder.vo.weichatGift.SoWechatGiftCancelVO;
import com.thebeastshop.salesorder.vo.weichatGift.SoWechatGiftInfoVO;
import com.thebeastshop.salesorder.vo.weichatGift.SoWechatGiftOrderVO;
import com.thebeastshop.salesorder.vo.weichatGift.SoWechatGiftSimpleVO;

import java.util.List;

/**
 * @ClassName: SoWechatGiftService
 * @Description: 微信送礼服务
 * @Author xiang.gao
 * @Date 2022/12/29 16:05
 */
public interface SoWechatGiftService {

    /**
     * 根据订单好查询送礼概要信息
     * @param orderCode
     * @return
     */
    ServiceResp<SoWechatGiftSimpleVO> getGiftByOrderCode(String orderCode);

    /**
     * 根据Id查询送礼信息
     * @param giftId
     * @return
     */
    ServiceResp<SoWechatGiftInfoVO> getGiftInfoById(Long giftId);

    /**
     * 根据订单号查询送礼信息
     * @param orderCode
     * @return
     */
    ServiceResp<SoWechatGiftInfoVO> getGiftInfoByOrderCode(String orderCode);

    /**
     * 接收礼物
     * @param giftReceiveDto
     * @return
     */
    ServiceResp receiveGift(SoWechatGiftReceiveDto giftReceiveDto);

    /**
     * 我的礼物列表
     * @param soWechatGiftQueryDto
     * @return
     */
    PageQueryResp<SoWechatGiftOrderVO> giftOrderList(SoWechatGiftQueryDto soWechatGiftQueryDto);

    /**
     * 礼物详情
     * @param giftId
     * @return
     */
    // ServiceResp<SoWechatGiftOrderVO> giftOrderDetail(Long giftId);

    /**
     * 获取需要取消的礼物
     * @return
     */
    List<SoWechatGiftCancelVO> getNeedCancelGiftList();

    /**
     * 取消礼物
     * @param orderCode
     * @return
     */
    ServiceResp cancelGift(String orderCode);




}
