package com.thebeastshop.salesorder.vo;

import com.thebeastshop.common.BaseDO;

import java.math.BigDecimal;
import java.util.Date;

/**
 * Desc: 导出退换货记录VO
 * Created by hafiz.zhang on 2017/2/17.
 */
public class SoReturnRequestExportVO extends BaseDO {
    private String channelName;                 // 渠道名称
    private String returnRequestCode;           // 退换货单号
    private String salesOrderCode;              // 源订单号
    private Date payTime;                       // 付款时间
    private String payWay;                      // 付款方式
    private Date returnTime;                    // 退货时间
    private String change;                      // 是否换货
    private String skuCode;                     // 退货sku code
    private String productName;                 // 产品名称
    private String firstCategory;               // 一级分类
    private String secondCategory;              // 二级分类
    private BigDecimal salePrice;               // 商品售价
    private Integer amount;                     // 数量
    private BigDecimal returnAmount;            // 退款金额
    private BigDecimal totalReturnAmount;       // 订单总退款金额
    private String crossBorder;                 // 是否海淘

    @Override
    public String toString() {
        return "OpReturnRequestExportVO{" +
                "channelName='" + channelName + '\'' +
                ", returnRequestCode='" + returnRequestCode + '\'' +
                ", salesOrderCode='" + salesOrderCode + '\'' +
                ", payTime=" + payTime +
                ", payWay='" + payWay + '\'' +
                ", returnTime=" + returnTime +
                ", change='" + change + '\'' +
                ", skuCode='" + skuCode + '\'' +
                ", productName='" + productName + '\'' +
                ", firstCategory='" + firstCategory + '\'' +
                ", secondCategory='" + secondCategory + '\'' +
                ", salePrice=" + salePrice +
                ", amount=" + amount +
                ", returnAmount=" + returnAmount +
                ", totalReturnAmount=" + totalReturnAmount +
                ", crossBorder='" + crossBorder + '\'' +
                '}';
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getReturnRequestCode() {
        return returnRequestCode;
    }

    public void setReturnRequestCode(String returnRequestCode) {
        this.returnRequestCode = returnRequestCode;
    }

    public String getSalesOrderCode() {
        return salesOrderCode;
    }

    public void setSalesOrderCode(String salesOrderCode) {
        this.salesOrderCode = salesOrderCode;
    }

    public Date getPayTime() {
        return payTime;
    }

    public void setPayTime(Date payTime) {
        this.payTime = payTime;
    }

    public String getPayWay() {
        return payWay;
    }

    public void setPayWay(String payWay) {
        this.payWay = payWay;
    }

    public Date getReturnTime() {
        return returnTime;
    }

    public void setReturnTime(Date returnTime) {
        this.returnTime = returnTime;
    }

    public String getChange() {
        return change;
    }

    public void setChange(String change) {
        this.change = change;
    }

    public String getSkuCode() {
        return skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getFirstCategory() {
        return firstCategory;
    }

    public void setFirstCategory(String firstCategory) {
        this.firstCategory = firstCategory;
    }

    public String getSecondCategory() {
        return secondCategory;
    }

    public void setSecondCategory(String secondCategory) {
        this.secondCategory = secondCategory;
    }

    public BigDecimal getSalePrice() {
        return salePrice;
    }

    public void setSalePrice(BigDecimal salePrice) {
        this.salePrice = salePrice;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public BigDecimal getReturnAmount() {
        return returnAmount;
    }

    public void setReturnAmount(BigDecimal returnAmount) {
        this.returnAmount = returnAmount;
    }

    public BigDecimal getTotalReturnAmount() {
        return totalReturnAmount;
    }

    public void setTotalReturnAmount(BigDecimal totalReturnAmount) {
        this.totalReturnAmount = totalReturnAmount;
    }

    public String getCrossBorder() {
        return crossBorder;
    }

    public void setCrossBorder(String crossBorder) {
        this.crossBorder = crossBorder;
    }
}
