package com.thebeastshop.salesorder.enums;

import com.thebeastshop.common.utils.EnumUtil;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;
import com.thebeastshop.payment.enums.PPaymentChannelGroupEnum;
import org.apache.commons.collections.CollectionUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-02-23 16:01
 */
public enum SoPaymentTypeEnum {
	TYPE_UNKNOW(-1, "未知"),
	CUSTOMER_SERVICE(0, "客服"),
	TYPE_CASH(1, "现金", PPaymentChannelGroupEnum.CASH, PPaymentChannelEnum.CASH),
	TYPE_CARD(2, "刷卡",PPaymentChannelGroupEnum.CREDIT_CARD, PPaymentChannelEnum.DEBIT_CARD, PPaymentChannelEnum.CREDIT_CARD),
	TYPE_WEIXIN(4, "微信",PPaymentChannelGroupEnum.WXPAY, PPaymentChannelEnum.WEIXIN_MOBILE, PPaymentChannelEnum.WEIXIN_MINI_PROGRAM, PPaymentChannelEnum.WEIXIN_SCAN, PPaymentChannelEnum.WEIXIN_USER_SCAN, PPaymentChannelEnum.WEIXIN_OFFICIAL_ACCOUNT, PPaymentChannelEnum.WEIXIN_DIRECT),
	TYPE_ALIPAY(5, "支付宝",PPaymentChannelGroupEnum.ALIPAY, PPaymentChannelEnum.ALIPAY_MOBILE, PPaymentChannelEnum.ALI_CROSS_BORDER_MOBILE, PPaymentChannelEnum.ALIPAY_DIRECT, PPaymentChannelEnum.ALI_BANK, PPaymentChannelEnum.ALIPAY_SCAN, PPaymentChannelEnum.ALIPAY_USER_SCAN, PPaymentChannelEnum.ALI_CROSS_BORDER_DIRECT, PPaymentChannelEnum.ALIPAY_WAP_DIRECT, PPaymentChannelEnum.ALI_WAP_CROSS_BORDER_DIRECT),
	TYPE_CMB(6, "招行",PPaymentChannelGroupEnum.CMB, PPaymentChannelEnum.CMB),
	TYPE_TRANSFER(7, "转账",PPaymentChannelGroupEnum.TRANSFER, PPaymentChannelEnum.TRANSFER),
	PRE_DEPOSIT(8, "预存款",PPaymentChannelGroupEnum.YCK, PPaymentChannelEnum.YCK),
	TYPE_PROPRIETOR(9, "业主",PPaymentChannelGroupEnum.YEZHU, PPaymentChannelEnum.YEZHU),
	TYPE_GIFT_CARD(10, "礼品卡",PPaymentChannelGroupEnum.GIFT_CARD, PPaymentChannelEnum.GIFT_CARD),
	TYPE_EXCHANGE(11,"积分",PPaymentChannelGroupEnum.INTEGRAL, PPaymentChannelEnum.INTEGRAL),
	TYPE_CMB_CSSH(12, "招行掌上生活",PPaymentChannelGroupEnum.CMB, PPaymentChannelEnum.CMB),
	TYPE_MARKET_COUPON(13, "商场券",PPaymentChannelGroupEnum.MARKET_COUPON, PPaymentChannelEnum.MARKET_COUPON),
	TYPE_QUICK_PASS(14, "银联云闪付", PPaymentChannelGroupEnum.QUICK_PASS_SCAN, PPaymentChannelEnum.QUICK_PASS_SCAN),
	TYPE_FUND(15, "基金", PPaymentChannelGroupEnum.FUND, PPaymentChannelEnum.FUND),
	TYPE_ELEME(16, "饿了么", PPaymentChannelGroupEnum.ELEME, PPaymentChannelEnum.ELEME),
	TYPE_TM_SHOPPING_FUND(17, "天猫购物金", PPaymentChannelGroupEnum.TM_SHOPPING_FUND, PPaymentChannelEnum.TM_SHOPPING_FUND),
	TYPE_TM_INTERESTS_FUND(18, "天猫权益金", PPaymentChannelGroupEnum.TM_INTERESTS_FUND, PPaymentChannelEnum.TM_INTERESTS_FUND),
	SHOPPING_MALL_APP(19, "商场小程序", PPaymentChannelGroupEnum.SHOPPING_MALL_APP, PPaymentChannelEnum.SHOPPING_MALL_APP),
	MARKETING_DISCOUNT(20, "商家支付营销优惠", PPaymentChannelGroupEnum.MERCHANTS_PAY_MARKETING_DISCOUNT, PPaymentChannelEnum.MERCHANTS_PAY_MARKETING_DISCOUNT),
	GROUP_BUYING_VOUCHER(21, "团购券", PPaymentChannelGroupEnum.GROUP_BUYING_VOUCHER, PPaymentChannelEnum.GROUP_BUYING_VOUCHER),
	WORK_WEIXIN_TRANSFER(22, "企微转账", PPaymentChannelGroupEnum.WORK_WEIXIN_TRANSFER, PPaymentChannelEnum.WORK_WEIXIN_TRANSFER),
	PAYPAL(23, "PayPal", PPaymentChannelGroupEnum.PAYPAL, PPaymentChannelEnum.PAYPAL),
	MANUAL(24, "Manual", PPaymentChannelGroupEnum.MANUAL, PPaymentChannelEnum.MANUAL),
	VISA(25, "Visa", PPaymentChannelGroupEnum.VISA, PPaymentChannelEnum.VISA),
	MASTERCARD(26, "MasterCard", PPaymentChannelGroupEnum.MASTERCARD, PPaymentChannelEnum.MASTERCARD),
	AMERICAN_EXPRESS(27, "American Express", PPaymentChannelGroupEnum.AMERICAN_EXPRESS, PPaymentChannelEnum.AMERICAN_EXPRESS);

	private Integer id;

	private String name;

	private PPaymentChannelGroupEnum refundChannelEnum;
	
	private List<PPaymentChannelEnum> paymentChannels;

	SoPaymentTypeEnum(Integer id, String name) {
		this.id = id;
		this.name = name;
	}

	SoPaymentTypeEnum(Integer id, String name, PPaymentChannelGroupEnum refundChannelEnum, PPaymentChannelEnum... paymentChannels) {
		this.id = id;
		this.name = name;
		this.refundChannelEnum = refundChannelEnum;
		if (paymentChannels != null && paymentChannels.length > 0) {
			this.paymentChannels = Arrays.asList(paymentChannels);
		}
	}
	public Integer getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public static SoPaymentTypeEnum getEnumById(Integer id) {
		for (SoPaymentTypeEnum e : SoPaymentTypeEnum.values()) {
			if (e.getId().equals(id)) {
				return e;
			}
		}
		return TYPE_UNKNOW;
	}

	public static String getNameById(Integer id) {
		return EnumUtil.getNameById(id, SoPaymentTypeEnum.class);
	}

	public PPaymentChannelGroupEnum getRefundChannelEnum() {
		return refundChannelEnum;
	}

	public List<PPaymentChannelEnum> getPaymentChannels() {
		return paymentChannels;
	}

	public static SoPaymentTypeEnum getByPaymentChannel(Integer paymentChannel) {
		for (SoPaymentTypeEnum soPaymentTypeEnum : SoPaymentTypeEnum.values()) {
			if (CollectionUtils.isNotEmpty(soPaymentTypeEnum.getPaymentChannels())) {
				for (PPaymentChannelEnum channel : soPaymentTypeEnum.getPaymentChannels()) {
					if (channel.getCode().equals(paymentChannel)) {
						return soPaymentTypeEnum;
					}
				}
			}
		}
		return TYPE_UNKNOW;
	}
}
