/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.salesorder.vo;

import com.thebeastshop.common.BaseDO;

import java.math.BigDecimal;

/**
 * @author Roy.Chen
 * @version $Id: OpSalesReportVO.java, v 0.1 2015-09-21 17:21
 */
public class SoReportVO extends BaseDO {
    /**
     * 支付方式
     */
    private Integer paymentType;
    private String payment;
    /**
     * 支付总金额
     */
    private BigDecimal needToPayAmount;
    /**
     * 退货总金额
     */
    private BigDecimal returnAmount;
    /**
     * 订单数
     */
    private Integer orderCount;
    /**
     * 总件数
     */
    private Integer skuQuantity;

    public String getPayment() {
        return payment;
    }

    public void setPayment(String payment) {
        this.payment = payment;
    }

    public BigDecimal getNeedToPayAmount() {
        return needToPayAmount == null?BigDecimal.ZERO:needToPayAmount;
    }

    public void setNeedToPayAmount(BigDecimal needToPayAmount) {
        this.needToPayAmount = needToPayAmount;
    }

    public BigDecimal getReturnAmount() {
        return returnAmount == null ? BigDecimal.ZERO : returnAmount;
    }

    public void setReturnAmount(BigDecimal returnAmount) {
        this.returnAmount = returnAmount;
    }

    public Integer getOrderCount() {
        return orderCount == null?0:orderCount;
    }

    public void setOrderCount(Integer orderCount) {
        this.orderCount = orderCount;
    }

    public Integer getSkuQuantity() {
        return skuQuantity == null?0:skuQuantity;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public void setSkuQuantity(Integer skuQuantity) {
        this.skuQuantity = skuQuantity;
    }
}
