package com.thebeastshop.privilege.enumeration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 生日到店礼状态枚举
 * @author LK
 *
 */
public enum BirthdayGiftVerificaRecordStatusEnum {

	NO_BIRTHDAY(0,"生日未设置"),
	USED(1, "已使用"),
	NO_USED(2, "待使用"),
	NO_ACTIVATE(3, "待激活"),
	ACTIVATED(4, "已激活"),
	NOT_AVAILABLE(5, "不可用"),
	EXPIRED(6, "已过期"),
	END(7, "活动已结束"),
	;

	public final Integer status;
	public final String desc;

	public static final List<BirthdayGiftVerificaRecordStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private BirthdayGiftVerificaRecordStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(int status) {

        for (BirthdayGiftVerificaRecordStatusEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
