package com.thebeastshop.privilege.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.InterestFreeCond;
import com.thebeastshop.privilege.vo.InterestFreeCashVO;
import com.thebeastshop.privilege.vo.InterestFreeProductVO;
import com.thebeastshop.privilege.vo.InterestFreeProvideVO;
import com.thebeastshop.privilege.vo.InterestFreeVO;

import java.util.List;
import java.util.Map;

/**
 * Created by xiaodong.cheng on 2018/11/13.
 */
public interface InterestFreeService {

    /**
     * 权益发放记录
     * @param cond
     * @return
     */
    List<InterestFreeProvideVO> listProvideRecords(InterestFreeCond cond);

    /**
     * 查询商品权益
     * @param id
     * @return
     */
    InterestFreeVO findById(Integer id);

    /**
     * 查询所有状态为正常的
     * @return
     */
    List<InterestFreeVO> findAvailableInterestFrees();

    /**
     * 更新商品权益
     * @param interestFreeVO
     * @return
     */
    ServiceResp<Boolean> update(InterestFreeVO interestFreeVO);

    /**
     * 插入商品权益
     * @param interestFreeVO
     * @return
     */
    ServiceResp<Boolean> insert(InterestFreeVO interestFreeVO);

    /**
     * 根据条件查询免邮权益
     * @param cond
     * @return
     */
    PageQueryResp<InterestFreeVO> list(InterestFreeCond cond);

    /**
     * 根据免邮权益ID,查询适用的商品
     * @param interestFreeId
     * @return
     */
    List<InterestFreeProductVO> getProdVOSByInterestFreeId(Integer interestFreeId);

    /**
     * 得到权益的剩余数量
     * @param interestId
     * @return
     */
    ServiceResp<Integer> getRemainingQuantityById(Integer interestId);



    /*******************************************以下接口提供外部调用*********************************************/
    /**
     * 发放免邮权益
     * @param memberId
     * @param interestFreeId
     * @param provideChannel
     * @return
     */
    ServiceResp<InterestFreeProvideVO> giveInterestFree(Integer memberId, Integer interestFreeId, String provideChannel);

    /**
     * 发放免邮权益
     * @param memberId
     * @param interestFreeId
     * @return
     */
    ServiceResp<InterestFreeProvideVO> giveInterestFree(Integer memberId, Integer interestFreeId);


    ServiceResp<Boolean> giveInterestFreeByBatch(List<Integer> memberIds, Integer interestFreeId);

    /**
     * 使用免邮权益
     * @param interestFreeCashVO
     * @return
     */
    ServiceResp<Boolean> cashInterestFree(InterestFreeCashVO interestFreeCashVO);

    /**获取可用免邮权益
     * @param interestFreeCashVO
     * @return
     */
    ServiceResp<InterestFreeVO> getOptimallyUsableInterestFree(InterestFreeCashVO interestFreeCashVO);

    /**
     * 获取免邮权益完整信息
     * @param provideId
     * @return
     */
    ServiceResp<InterestFreeVO> findInterestFreeFullInfoByProvideId(Integer provideId);

    /**
     * 获取免邮权益完整信息
     * @param provideIds
     * @return
     */
    ServiceResp<Map<Integer,InterestFreeVO>> findInterestFreeFullInfoByProvideIds(List<Integer> provideIds);

    /**
     * 根据会员ID获取权益信息
     * @param memberId
     * @return
     */
    ServiceResp<List<InterestFreeVO>> findInterestFreeInfoByMemberId(Integer memberId);

    /**
     * 根据会员ID获取权益信息
     * @param memberId
     * @return
     */
    ServiceResp<List<InterestFreeVO>> findInterestFreeInfoByMemberIdAndId(Integer memberId,Integer id);

    /**
     * 获取在day天后过期的免邮权益
     * @param day
     * @return
     */
    ServiceResp<List<InterestFreeVO>> getAllExpInterestFreeAfterDay(Integer day);

    /**
     * 修改面有用户所属用户
     * @param memberId
     * @param toMemberId
     * @return
     */
    ServiceResp<Boolean> changeMember(Integer memberId,Integer toMemberId);

    /**
     * 返还免邮权益
     * @param provideId
     * @return
     */
    ServiceResp<Boolean> backInterestFreeByProvideId(Integer provideId);


}
