package com.thebeastshop.privilege.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.PrivilegeCodeExchangeCond;
import com.thebeastshop.privilege.cond.PrivilegeCodeExchangeRecordCond;
import com.thebeastshop.privilege.dto.BirthdayGiftDTO;
import com.thebeastshop.privilege.vo.BirthdayGiftVO;
import com.thebeastshop.privilege.vo.PrivilegeCodeExchangeRecordVO;
import com.thebeastshop.privilege.vo.PrivilegeCodeExchangeVO;
import com.thebeastshop.privilege.vo.ValueLabelVO;

import java.util.List;
import java.util.Map;

/**
 * Created by gensheng.ye on 2019/8/5.
 */
public interface PrivilegeCodeExchangeService {
    //兑换记录查询
    ServiceResp<PageQueryResp<PrivilegeCodeExchangeRecordVO>> findRecordByCond(PrivilegeCodeExchangeRecordCond cond);
    //查询所有特权名称
    List<Map<Integer,String>> getAllPrivilegeDetailNames(Integer privilegeId);
    //导出记录
    List<PrivilegeCodeExchangeRecordVO> findByCondByExport(PrivilegeCodeExchangeRecordCond cond);

    ServiceResp<PageQueryResp<PrivilegeCodeExchangeVO>> findCond(PrivilegeCodeExchangeCond cond);
    ServiceResp<Integer> create(PrivilegeCodeExchangeVO vo);
    ServiceResp<Boolean> update(PrivilegeCodeExchangeVO vo);
    ServiceResp<PrivilegeCodeExchangeVO> findById(Integer id);
    ServiceResp<List<ValueLabelVO>> getCreateUserIdNameList();
}