package com.thebeastshop.privilege.vo;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

/**
 * Created by xiaodong.cheng on 2019/8/23.
 */
public class Pagination<E> implements Serializable {

    private Integer maxPages = 0;

    private Integer currpage = 1;

    private Integer offset = Integer.valueOf(0);  //返回给app的偏量值

    private Integer pagenum = 0;

    private Integer record;

    private Integer currPageFirstSerNo = 1;

    private List<E> resultList;
    /**
     * 默认页面记录数
     */
    public final static Integer DEFAULT_SIZE = 10;

    public Pagination() {
        super();
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;

    }

    public Pagination(Integer page, Integer size) {
        super();
        this.currpage = page;
        this.pagenum = size;

    }

    public Pagination(Integer maxPages, Integer currpage, Integer pagenum, Integer record) {
        super();
        this.maxPages = maxPages;
        this.currpage = currpage;
        this.pagenum = pagenum;
        this.record = record;
    }

    /**
     * 返回最大页数
     * @return
     */
    public Integer getMaxPages() {
        float nrOfPages = (float) this.getRecord() / this.getPagenum();
        this.maxPages = (int) ((nrOfPages > (int) nrOfPages || nrOfPages == 0.0) ? nrOfPages + 1 : nrOfPages);
        return maxPages;
    }

    public Integer getCurrpage() {
        return currpage;
    }

    public void setCurrpage(Integer currpage) {
        this.currpage = currpage;
    }

    public Integer getPagenum() {
        if (pagenum == null) return 1;
        return pagenum;
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }

    /**
     * 返回总记录数
     * @return
     */
    public Integer getRecord() {
        this.record = ((this.record == null || this.record < 0) ? 0 : this.record);
        return record;
    }

    public List<E> getResultList() {
        if(this.resultList == null) {
            this.resultList = Collections.emptyList();
        }
        return resultList;
    }

    public List<E> getResultListClone() {
        if(this.resultList == null) {
            this.resultList = Collections.emptyList();
        }
        return Collections.unmodifiableList(resultList);
    }

    public void add(E e){
        resultList.add(e);
    }

    public boolean remove(E e){
        if(e != null){
            return resultList.remove(e);
        }
        return false;
    }

    public void setResultList(List<E> resultList) {
        this.resultList = resultList;
        this.offset = (this.currpage-1)*this.pagenum+resultList.size();
    }

    public void setRecord(Integer record) {
        this.record = record;
    }

    public Object getCurrPageFirstSerNo() {
        int firstSerNo = (this.getCurrpage()==0?0:this.getCurrpage()-1)*this.getPagenum()+1;
        this.currPageFirstSerNo = firstSerNo;
        return currPageFirstSerNo;
    }

    public void setCurrPageFirstSerNo(Integer currPageFirstSerNo) {
        this.currPageFirstSerNo = currPageFirstSerNo;
    }
}
