package com.thebeastshop.privilege.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.AccelerateUpgradeTaskCond;
import com.thebeastshop.privilege.cond.AccelerateUpgradeTaskMemberCond;
import com.thebeastshop.privilege.vo.AccelerateUpgradeTaskMemberVO;
import com.thebeastshop.privilege.vo.AccelerateUpgradeTaskVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * Created by gensheng.ye on 2020/9/17.
 */
public interface AccelerateUpgradeTaskService {
    ServiceResp<Integer> create(AccelerateUpgradeTaskVO taskVO);
    ServiceResp<Boolean> update(AccelerateUpgradeTaskVO taskVO);
    ServiceResp updateStatus(AccelerateUpgradeTaskVO vo);
    ServiceResp saveUpgradeTaskMember(List<AccelerateUpgradeTaskMemberVO> taskMemberVoList);
    ServiceResp<Integer> updateTaskMember(List<AccelerateUpgradeTaskMemberVO> taskMemberVOList);
    ServiceResp<Integer> deleteMember(Integer upgradeTaskId,List<Integer> detailIds);

    ServiceResp<AccelerateUpgradeTaskVO> findById(Integer id);
    ServiceResp<PageQueryResp<AccelerateUpgradeTaskVO>> findCond(AccelerateUpgradeTaskCond cond);
    ServiceResp<List<AccelerateUpgradeTaskVO>> findCreateList();


    ServiceResp<PageQueryResp<AccelerateUpgradeTaskMemberVO>> findMemberCond(AccelerateUpgradeTaskMemberCond cond);
    ServiceResp<List<AccelerateUpgradeTaskMemberVO>> findMemberByCodes(Integer upgradeTaskId, List<String> memberCodes);
    ServiceResp<List<AccelerateUpgradeTaskMemberVO>> findTaskOtherMember(Integer currentTaskId,List<Integer> listTaskId);
    ServiceResp<List<AccelerateUpgradeTaskMemberVO>> findDetailIds(Integer upgradeTaskId,List<Integer> detailIds);

    ServiceResp updateHasJoin(Integer upgradeTaskMemberId,Integer taskId);
    ServiceResp updateOldRequireAmount(AccelerateUpgradeTaskMemberVO vo);
    ServiceResp<PageQueryResp<AccelerateUpgradeTaskMemberVO>> getAcceUpgradeRecordByCond(AccelerateUpgradeTaskMemberCond cond);


}