package com.thebeastshop.privilege.exception;

/**
 * Created by xiaodong.cheng on 2018/1/29.
 */
public class PrivilegeBusinessException extends RuntimeException{

    private static final long serialVersionUID = 417037933215357313L;
    private String retCode;
    private String retMsg;

    public static PrivilegeBusinessException instance(PrivilegeBusinessMsg privilegeBusinessMsg){
        return instance(privilegeBusinessMsg,null);
    }

    public static PrivilegeBusinessException instance(PrivilegeBusinessMsg privilegeBusinessMsg, Throwable thr){
        String code = "";
        String msg = "";
        if(null != privilegeBusinessMsg){
            code = privilegeBusinessMsg.getCode();
            msg = privilegeBusinessMsg.getMsg();
        }
        return new PrivilegeBusinessException(code, msg, thr);
    }

    public PrivilegeBusinessException(String retCode, String retMsg){
        super("[retCode=" + retCode + ", retMsg=" + retMsg + "]");
        this.retCode = retCode;
        this.retMsg = retMsg;
    }

    public PrivilegeBusinessException(String retCode, String retMsg, Throwable thr){
        super("[retCode=" + retCode + ", retMsg=" + retMsg + "]");
        this.retCode = retCode;
        this.retMsg = retMsg;
        this.initCause(thr);
    }

    public String getRetCode() {
        return retCode;
    }

    public void setRetCode(String retCode) {
        this.retCode = retCode;
    }

    public String getRetMsg() {
        return retMsg;
    }

    public void setRetMsg(String retMsg) {
        this.retMsg = retMsg;
    }

}
