package com.thebeastshop.privilege.service;

import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.privilege.cond.KeyMemberMemorialCond;
import com.thebeastshop.privilege.cond.KeyMemberMemorialRecordCond;
import com.thebeastshop.privilege.vo.KeyMemberMemorialCustomVO;
import com.thebeastshop.privilege.vo.KeyMemberMemorialRecordVO;
import com.thebeastshop.privilege.vo.KeyMemberMemorialVO;
import com.thebeastshop.privilege.vo.ValueLabelIntVO;
import org.apache.ibatis.annotations.Delete;

import java.util.List;

/**
 * @Description: 店铺重点会员管理
 * @Version: 1.0
 */
public interface KeyMemberMemorialService {

    List<ValueLabelIntVO> getSystemMemberMemorial();

    ServiceResp<PageQueryResp<KeyMemberMemorialVO>> findCond(KeyMemberMemorialCond cond);
    ServiceResp<Integer> save(KeyMemberMemorialVO vo);
    ServiceResp saveMemorialCustom(KeyMemberMemorialCustomVO customVO);
    ServiceResp<KeyMemberMemorialCustomVO> findMemorialDayEdit(Integer memorialId,String cellPhone);
    ServiceResp<KeyMemberMemorialVO> findById(Integer id);
    ServiceResp<List<KeyMemberMemorialRecordVO>> findRecordList(KeyMemberMemorialRecordCond cond);



}
