package com.thebeastshop.privilege.enumeration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 生日礼状态枚举
 * @author LK
 *
 */
public enum BirthdayGiftStatusEnum {
	INIT(0, "初始态"),
	COMMINT(1, "已提交"),
	INVALID(2, "作废"),
	OFFLINE(3, "已下线"),
	STAYONLINE(4, "待上线"),
	ONLINE(5, "已上线")
	;

	public final Integer status;
	public final String desc;

	public static final List<BirthdayGiftStatusEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private BirthdayGiftStatusEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(int status) {

        for (BirthdayGiftStatusEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
