package com.thebeastshop.privilege.service;


import com.thebeastshop.common.PageQueryResp;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.hotlink.annotation.Hotlink;
import com.thebeastshop.privilege.cond.InterestGoodsCond;
import com.thebeastshop.privilege.cond.InterestGoodsProvideCond;
import com.thebeastshop.privilege.dto.DeleteInterestGoodsProvideDTO;
import com.thebeastshop.privilege.vo.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by xiaodong.cheng on 2018/1/18. * 权益商品服务
 */
public interface InterestGoodsService {

    /**
     * 查找所有状态为正常的商品权益
     * @return
     */
    List<InterestGoodsDetailVO> findAvailableInterestGoods();

    /**
     * 发放权益
     * @param memberId
     * @param interestGoodsId
     * @return
     */
    @Deprecated
    InterestGoodsGiveVO giveInterestGoods(Integer memberId, Integer interestGoodsId);

    /**
     * 批量发放权益
     * @param memberIds
     * @param interestGoodsId
     * @return
     */
    Boolean giveInterestGoods(List<Integer> memberIds, Integer interestGoodsId);

    /**
     * 根据条件查询权益
     * @param cond
     * @return
     */
    PageQueryResp<InterestGoodsDetailVO> list(InterestGoodsCond cond);

    List<InterestGoodsDetailExportVO> listExport(InterestGoodsCond cond);

    /**
     * 权益发放记录
     * @param cond
     * @return
     */
    List<InterestGoodsProvideVO> listProvideRecords(InterestGoodsCond cond);

    /**
     * 查询商品权益
     * @param interestGoodsId
     * @return
     */
    InterestGoodsVO getInteretGoodsById(Integer interestGoodsId);
    InterestGoodsVO getInteretGoodsByProvideId(Integer interestGoodsProvideId);
    ServiceResp<InterestGoodsVO> getInteretGoodsAndQuantityById(Integer interestGoodsId);

    /**
     * 查询商品权益及SKU信息
     * @param interestGoodsId
     * @return
     * @throws Exception
     */
    InterestGoodsAndSkuVO getInterestGoodsAndSkus(Integer interestGoodsId);
    /**
     * 查询商品权益及SKU信息
     * @param interestGoodsProvideId
     * @return
     * @throws Exception
     */
    InterestGoodsAndSkuVO getInterestGoodsAndSkusByProvideId(Integer interestGoodsProvideId);

    List<InterestGoodsAndSkuVO> getInterestGoodsAndSkusByProvideIds(List<Integer> interestGoodsProvideIds);

    InterestGoodsAndSkuVO getInterestGoodsAndSkusByProvideId(Integer interestGoodsProvideId,Integer memberId);

    InterestGoodsSkuVO getInterestGoodsSkuBySkuCode(Integer interestGoodsId,String skuCode);
    InterestGoodsSkuVO getInterestGoodsSkuByProvideId(Integer interestGoodsProvideId);

    InterestGoodsSkuVO getInterestGoodsSkuByPresaleId(Integer interestGoodsId,Integer presaleId);

    /**
     * 查询商品权益数量
     * @param interestGoodsId
     * @return
     */
    int getQuantitySumByInterestId(Integer interestGoodsId);


    /**
     * 保存商品权益
     * @param interestGoodsSaveVO
     * @return
     */
    Integer saveInterestGoods(InterestGoodsSaveVO interestGoodsSaveVO);

    /**
     * 删除商品权益
     * @param interestGoodsId
     */
    void delete(int interestGoodsId);


    Map<Integer, Integer> getCashQuantity(Set<Integer> interestGoodsSkuIds);

    List<Map<Integer,String>>  getAllCreators();

//    /**
//     * 兑换商品权益
//     * @param memberId
//     * @param interestGoodsSkuVOS
//     */
//   public void cash(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOS);


    List<InterestGoodsSkuVO> findValidInterestGoodsSkuVOS(String skuCode);

   /***************************************给C端调用**********************************/

    /**
     * 发放商品权益
     * @param memberId
     * @param interestGoodsId
     * @return
     */
    ServiceResp<InterestGoodsGiveVO>  giveInterestGoodsNew(Integer memberId, Integer interestGoodsId);

    /**
     * 发放权益（是否展示购物车）
     * @param memberId
     * @param interestGoodsId
     * @return
     */
    ServiceResp<InterestGoodsGiveVO>  giveInterestGoodsNew(Integer memberId, Integer interestGoodsId,Integer isShowCart);

    /**
     * 批量发放商品权益
     * @param memberId
     * @param interestGoodsId
     * @param num
     * @return
     */
    ServiceResp<InterestGoodsGiveVO> giveInterestGoods(Integer memberId, Integer interestGoodsId, Integer num);

    /**
     * 兑换商品权益(废弃)
     * @param memberId
     * @param interestGoodsSkuVOS
     */
//    ServiceResp<Boolean> cashInterestGoods(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOS);

    /**
     * 新兑换商品权益
     * @param memberId
     * @param interestGoodsSkuVOS
     */
    ServiceResp<Boolean> cashInterestGoodsNew(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOS);

    /**
     * 返还商品权益
     * @param memberId
     * @param interestGoodsSkuVOS
     * @return
     */
    ServiceResp<Boolean> backInterestGoods(Integer memberId, List<InterestGoodsSkuVO> interestGoodsSkuVOS);

    /**
     * 更新用户一个商品权益ID下的权益SKU记录(多规则商品)
     * @param memberId 会员ID
     * @param sourceInterestGoodsProvideId 原来的权益记录 ID
     * @param destInterestGoodsSkuId 更换的目标权益SKU ID
     * @return 更新是否成功
     */
//    ServiceResp<Boolean> changeInterestGoodsSku(Integer memberId, Integer sourceInterestGoodsSkuId, Integer destInterestGoodsSkuId,Integer quantity);
    ServiceResp<Boolean> changeInterestGoodsSkuByProvideId(Integer memberId, Integer sourceInterestGoodsProvideId, Integer destInterestGoodsSkuId);

    /**
     * 获取已兑换数量
     * @param interestGoodsSkuIds
     * @return
     */
    ServiceResp<Map<Integer,Integer>> getCashQuantityNew(Set<Integer> interestGoodsSkuIds);

    /**
     * 获取商品权益领取记录
     * @param cond
     * @return
     */
    ServiceResp<List<InterestGoodsProvideVO>> listProvideRecordsNew(InterestGoodsCond cond);

    ServiceResp<PageQueryResp<InterestGoodsProvideVO>> queryProvideRecords(InterestGoodsProvideCond cond);

    /**
     * 得到 day 天后过期的商品权益发放记录
     * @param day
     * @return
     */
    ServiceResp<List<InterestGoodsGiveVO>> getExpInterestGoodsGiveVOS(Integer day);
    ServiceResp<Integer> sendExpInterestGoodsInfo(Integer day);
    ServiceResp<Integer> sendExpInterestGoodsInfo();

    /**
     * 更改商品权益所属用户
     * @param memberId
     * @param toMemberId
     * @return
     */
    ServiceResp<Boolean> changeMember(Integer memberId,Integer toMemberId);

    /**
     * 批量更新过期的商品权益状态
     * @return
     */
    ServiceResp<Boolean> updateExpirationGoods();

    /**
     * 批量释放领取时间过期的未领取的商品权益库存
     * @return
     */
    ServiceResp<Boolean> releaseOverReceivedTimeGoodsStock();

    /**
     * 根据会员ID,查询商品权益信息
     * @param memberId
     * @return
     */
    ServiceResp<List<InterestGoodsProvideVO>> findInterestGoodsInfoByMemberId(Integer memberId);

    /**
     * 根据会员ID,查询可用商品权益信息
     * @param memberId
     * @return
     */
    @Hotlink
    ServiceResp<List<InterestGoodsAndSkuVO>> findInterestGoodsInfoByMemberIdForApp(Integer memberId);


    ServiceResp<List<InterestGoodsProvideVO>> findInterestGoodsInfo(Integer memberId,List<Integer> interestGoodsIds);

    //可领取数量小于等于0时通知
    ServiceResp usableQuantityLessThanOrEqualZeroNotice();

    List<InterestGoodsProvideVO> findByCondByExport(InterestGoodsProvideCond cond);
    //删除权益记录
    ServiceResp<Map<Integer,List<Integer>>> deleteInterestGoodsProvideIdsByMemberId(Integer memberId,List<DeleteInterestGoodsProvideDTO> dtos);

    void gsTest();
}
