/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.price.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.price.enums.PrsPriceTypeEnum;
import com.thebeastshop.price.vo.PrsAdditionalPackVO;
import com.thebeastshop.price.vo.PrsCampaignVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class PrsPriceStepVO
extends BaseDO {
    private static final long serialVersionUID = 1L;
    private PrsPriceTypeEnum priceType;
    private Long extId;
    private BigDecimal priceChange;
    private String stepDesc;
    private PrsCampaignVO campaign;
    private List<PrsAdditionalPackVO> additionalPackList;

    public PrsPriceStepVO() {
    }

    public PrsPriceStepVO(PrsPriceTypeEnum priceType, Long extId, BigDecimal savedPrice) {
        this.priceType = priceType;
        this.extId = extId;
        this.priceChange = savedPrice.negate();
        this.generateStepDesc();
    }

    public PrsPriceStepVO(PrsPriceTypeEnum priceType, Long extId, BigDecimal savedPrice, PrsCampaignVO campaign) {
        this.priceType = priceType;
        this.extId = extId;
        this.priceChange = savedPrice.negate();
        this.campaign = campaign;
        this.generateStepDesc();
    }

    public PrsPriceStepVO(PrsPriceTypeEnum priceType, Long extId, BigDecimal savedPrice, PrsCampaignVO campaign, List<PrsAdditionalPackVO> additionalPackList) {
        this.priceType = priceType;
        this.extId = extId;
        this.priceChange = savedPrice.negate();
        this.campaign = campaign;
        this.additionalPackList = additionalPackList;
        this.generateStepDesc();
    }

    private void generateStepDesc() {
        this.stepDesc = this.campaign != null ? this.campaign.getName() : this.priceType.getName();
    }

    public PrsCampaignVO getCampaign() {
        return this.campaign;
    }

    public void setCampaign(PrsCampaignVO campaign) {
        this.campaign = campaign;
    }

    public List<PrsAdditionalPackVO> getAdditionalPackList() {
        return this.additionalPackList;
    }

    public void setAdditionalPackList(List<PrsAdditionalPackVO> additionalPackList) {
        this.additionalPackList = additionalPackList;
    }

    public void addAdditionalPack(PrsAdditionalPackVO additionalPackVO) {
        if (CollectionUtils.isEmpty(this.additionalPackList)) {
            this.additionalPackList = new ArrayList<PrsAdditionalPackVO>();
        }
        this.additionalPackList.add(additionalPackVO);
    }

    public PrsPriceTypeEnum getPriceType() {
        return this.priceType;
    }

    public void setPriceType(PrsPriceTypeEnum priceType) {
        this.priceType = priceType;
    }

    public Long getExtId() {
        return this.extId;
    }

    public void setExtId(Long extId) {
        this.extId = extId;
    }

    public BigDecimal getPriceChange() {
        return this.priceChange;
    }

    public void setPriceChange(BigDecimal priceChange) {
        this.priceChange = priceChange;
    }

    public String getStepDesc() {
        return this.stepDesc;
    }

    public void setStepDesc(String stepDesc) {
        this.stepDesc = stepDesc;
    }
}

