/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.payment.enums;

import com.thebeastshop.common.enums.CodeEnum;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;
import java.util.Arrays;
import java.util.List;

public enum PPaymentChannelGroupEnum implements CodeEnum<Integer>
{
    ALIPAY(1, "\u652f\u4ed8\u5b9d", PPaymentChannelEnum.ALIPAY_MOBILE, PPaymentChannelEnum.ALIPAY_DIRECT, PPaymentChannelEnum.ALIPAY_SCAN, PPaymentChannelEnum.ALIPAY_WAP_DIRECT, PPaymentChannelEnum.ALIPAY_USER_SCAN, PPaymentChannelEnum.ALI_BANK, PPaymentChannelEnum.ALI_CROSS_BORDER_MOBILE, PPaymentChannelEnum.ALI_CROSS_BORDER_DIRECT, PPaymentChannelEnum.ALI_WAP_CROSS_BORDER_DIRECT),
    WXPAY(2, "\u5fae\u4fe1", PPaymentChannelEnum.WEIXIN_MOBILE, PPaymentChannelEnum.WEIXIN_MINI_PROGRAM, PPaymentChannelEnum.WEIXIN_SCAN, PPaymentChannelEnum.WEIXIN_OFFICIAL_ACCOUNT, PPaymentChannelEnum.WEIXIN_USER_SCAN, PPaymentChannelEnum.WEIXIN_DIRECT),
    CASH(3, "\u73b0\u91d1", PPaymentChannelEnum.CASH),
    DEBIT_CARD(4, "\u501f\u8bb0\u5361", PPaymentChannelEnum.DEBIT_CARD),
    CREDIT_CARD(5, "\u4fe1\u7528\u5361", PPaymentChannelEnum.CREDIT_CARD),
    TRANSFER(6, "\u8f6c\u8d26", PPaymentChannelEnum.TRANSFER),
    YCK(7, "\u9884\u5b58\u6b3e", PPaymentChannelEnum.YCK),
    YEZHU(8, "\u4e1a\u4e3b", PPaymentChannelEnum.YEZHU),
    GIFT_CARD(9, "\u793c\u54c1\u5361", PPaymentChannelEnum.GIFT_CARD),
    INTEGRAL(10, "\u79ef\u5206", PPaymentChannelEnum.INTEGRAL),
    CMB(11, "\u62db\u5546\u94f6\u884c", PPaymentChannelEnum.CMB),
    MARKET_COUPON(12, "\u5546\u573a\u5238", PPaymentChannelEnum.MARKET_COUPON),
    QUICK_PASS_SCAN(13, "\u94f6\u8054\u4e91\u95ea\u4ed8", PPaymentChannelEnum.QUICK_PASS_SCAN),
    FUND(14, "\u57fa\u91d1", PPaymentChannelEnum.FUND),
    ELEME(15, "\u997f\u4e86\u4e48", PPaymentChannelEnum.ELEME),
    TM_SHOPPING_FUND(16, "\u5929\u732b\u8d2d\u7269\u91d1", PPaymentChannelEnum.TM_SHOPPING_FUND),
    TM_INTERESTS_FUND(17, "\u5929\u732b\u6743\u76ca\u91d1", PPaymentChannelEnum.TM_INTERESTS_FUND),
    SHOPPING_MALL_APP(18, "\u5546\u573a\u5c0f\u7a0b\u5e8f", PPaymentChannelEnum.SHOPPING_MALL_APP);

    private Integer id;
    private String name;
    private List<PPaymentChannelEnum> paymentChannels;

    private PPaymentChannelGroupEnum(Integer id, String name, PPaymentChannelEnum ... paymentChannels) {
        this.id = id;
        this.name = name;
        if (paymentChannels == null || paymentChannels.length <= 0) {
            throw new IllegalArgumentException("\u9000\u6b3e\u5173\u8054\u7684\u652f\u4ed8\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        this.paymentChannels = Arrays.asList(paymentChannels);
    }

    public Integer getCode() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<PPaymentChannelEnum> getPaymentChannels() {
        return this.paymentChannels;
    }

    public static PPaymentChannelGroupEnum getEnumByCode(Integer code) {
        for (PPaymentChannelGroupEnum e : PPaymentChannelGroupEnum.values()) {
            if (!e.getCode().equals(code)) continue;
            return e;
        }
        return null;
    }

    public static PPaymentChannelGroupEnum getEnumByPaymentChannelCode(Integer paymentChannelCode) {
        PPaymentChannelEnum paymentChannel = PPaymentChannelEnum.getEnumByCode(paymentChannelCode);
        for (PPaymentChannelGroupEnum e : PPaymentChannelGroupEnum.values()) {
            if (!e.getPaymentChannels().contains((Object)paymentChannel)) continue;
            return e;
        }
        return null;
    }
}

