package com.thebeastshop.payment.dto;

import org.apache.commons.lang3.StringUtils;

import com.thebeastshop.payment.enums.PPaymentChannelEnum;

/**
 * 阿里网银支付
 * 
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-12-14 16:54
 */
public class PAlipayBankPaymentDTO extends PPaymentDTO {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	// 银行编号
	private String bankCode;

	/**
	 * 支付返回链接
	 */
	private String returnUrl;

	public PAlipayBankPaymentDTO() {
		super(PPaymentChannelEnum.ALI_BANK);
	}

	public String getBankCode() {
		return bankCode;
	}

	public void setBankCode(String bankCode) {
		this.bankCode = bankCode;
	}

	@Override
	public String getPaymentBusinessCode() {
		if (StringUtils.isNotBlank(bankCode)) {
			return bankCode;
		}
		return super.getPaymentBusinessCode();
	}

	public String getReturnUrl() {
		return returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

}
