package com.thebeastshop.payment.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;
import com.thebeastshop.payment.enums.PTransTypeEnum;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 支付参数
 *
 * @author Paul-xiong
 * @date 2017年11月10日
 */
public class PPaymentDTO extends BaseDO {

    /**
     *
     */
    private static final long serialVersionUID = 1L;
    /**
     * 访问来源
     */
    protected AccessWayEnum accessWay = AccessWayEnum.UNKNOWN;
    /**
     * 渠道号
     */
    protected String channelCode;
    /**
     * 渠道名称
     */
    protected String channelName;
    /**
     * 交易类型
     */
    protected PTransTypeEnum transType = PTransTypeEnum.ORDER_PAY;
    /**
     * 会员ID
     */
    protected Long memberId;
    /**
     * 支付渠道
     */
    protected PPaymentChannelEnum paymentChannel;
    /**
     * 订单金额
     */
    private BigDecimal orderAmount;
    /**
     * 应付金额
     */
    protected BigDecimal paymentAmount;
    /**
     * 外部流水号
     */
    protected String outTradeCode;
    /**
     * 业务编号
     */
    protected String paymentBusinessCode;
    /**
     * 操作人ID
     */
    private Integer operatorId;

    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 备注
     */
    protected String remark;
    /**
     * 支付超时时间，单位秒
     */
    private Long timeout;
    /**
     * 扩展字段
     */
    protected Map<String, String> extensions = new HashMap<>();
    /**
     * 仅记录支付流水，不执行支付业务
     */
    private boolean onlyRecord = false;

    public PPaymentDTO() {
    }

    protected PPaymentDTO(PPaymentChannelEnum paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public AccessWayEnum getAccessWay() {
        return accessWay;
    }

    public void setAccessWay(AccessWayEnum accessWay) {
        this.accessWay = accessWay;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public PTransTypeEnum getTransType() {
        return transType;
    }

    public void setTransType(PTransTypeEnum transType) {
        this.transType = transType;
    }

    public void setPaymentChannel(PPaymentChannelEnum paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public PPaymentChannelEnum getPaymentChannel() {
        return paymentChannel;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public String getOutTradeCode() {
        return outTradeCode;
    }

    public void setOutTradeCode(String outTradeCode) {
        this.outTradeCode = outTradeCode;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Map<String, String> getExtensions() {
        return extensions;
    }

    public void setExtensions(Map<String, String> extensions) {
        this.extensions = extensions;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getPaymentBusinessCode() {
        return paymentBusinessCode;
    }

    public void setPaymentBusinessCode(String paymentBusinessCode) {
        this.paymentBusinessCode = paymentBusinessCode;
    }

    public Integer getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Integer operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public Long getTimeout() {
        return timeout;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public boolean isOnlyRecord() {
        return onlyRecord;
    }

    public void setOnlyRecord(boolean onlyRecord) {
        this.onlyRecord = onlyRecord;
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }
}
