package com.thebeastshop.payment.enums;

import com.thebeastshop.common.enums.CodeEnum;

public enum PWxCardCertificatesStatusEnum implements CodeEnum<Integer> {
    EFFECTIVE(1, "有效"),
    INVALID(0, "无效"),
    ;

    private Integer code;

    private String name;

    PWxCardCertificatesStatusEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static PWxCardCertificatesStatusEnum getEnumByCode(Integer code) {
        for (PWxCardCertificatesStatusEnum e : PWxCardCertificatesStatusEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

}
