package com.thebeastshop.payment.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.thebeastshop.common.BaseDO;

import java.util.Date;
import java.util.List;

public class WxCardCertRespVO extends BaseDO {

    @JSONField(name = "data")
    private List<WxCardCertVO> data;

    public List<WxCardCertVO> getData() {
        return data;
    }

    public void setData(List<WxCardCertVO> data) {
        this.data = data;
    }

    public static class WxCardCertVO{
        @JSONField(name = "serial_no")
        private String serialNo;

        @JSONField(name = "effective_time")
        private Date effectiveTime;

        @JSONField(name = "expire_time")
        private Date expireTime;

        @JSONField(name = "encrypt_certificate")
        private EncryptCertificate encryptCertificate;

        public String getSerialNo() {
            return serialNo;
        }

        public void setSerialNo(String serialNo) {
            this.serialNo = serialNo;
        }

        public Date getEffectiveTime() {
            return effectiveTime;
        }

        public void setEffectiveTime(Date effectiveTime) {
            this.effectiveTime = effectiveTime;
        }

        public Date getExpireTime() {
            return expireTime;
        }

        public void setExpireTime(Date expireTime) {
            this.expireTime = expireTime;
        }

        public EncryptCertificate getEncryptCertificate() {
            return encryptCertificate;
        }

        public void setEncryptCertificate(EncryptCertificate encryptCertificate) {
            this.encryptCertificate = encryptCertificate;
        }
    }

    public static class EncryptCertificate{

        @JSONField(name = "algorithm")
        private String algorithm;

        @JSONField(name = "nonce")
        private String nonce;

        @JSONField(name = "associated_data")
        private String associatedData;

        @JSONField(name = "ciphertext")
        private String ciphertext;

        public String getAlgorithm() {
            return algorithm;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getNonce() {
            return nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getAssociatedData() {
            return associatedData;
        }

        public void setAssociatedData(String associatedData) {
            this.associatedData = associatedData;
        }

        public String getCiphertext() {
            return ciphertext;
        }

        public void setCiphertext(String ciphertext) {
            this.ciphertext = ciphertext;
        }
    }
}
