package com.thebeastshop.payment.dto;

import com.thebeastshop.payment.enums.PPaymentChannelEnum;

/**
 * 支付宝跨境购支付
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-12-18 12:08
 */
public class PAliCrossBorderMobilePaymentDTO extends PPaymentDTO {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 包含SKU名称和相应数量的货物信息，格式为SKU_name^quantity。如果存在多个商品，则使用竖线(|)分隔值
	 * eg: pencil^2|eraser^5|iPhone XS 256G^1
	 */
	private String goodsInfo;

	/**
	 * 订单中所有货物的总数量
	 */
	private String totalQuantity;

	public PAliCrossBorderMobilePaymentDTO() {
        super(PPaymentChannelEnum.ALI_CROSS_BORDER_MOBILE);
    }

	public String getGoodsInfo() {
		return goodsInfo;
	}

	public void setGoodsInfo(String goodsInfo) {
		this.goodsInfo = goodsInfo;
	}

	public String getTotalQuantity() {
		return totalQuantity;
	}

	public void setTotalQuantity(String totalQuantity) {
		this.totalQuantity = totalQuantity;
	}
}
