package com.thebeastshop.payment.enums;

import com.thebeastshop.common.exception.BaseErrorCode;

/**
 * @author Paul-xiong
 * @date 2017年11月10日
 * @description 错误编码
 */
public enum PPaymentErrorCodeEnum implements BaseErrorCode {
    PARAM_ERROR("0001", "参数错误"),
    SYSTEM_ERROR("0002", "系统错误"),
    TRADE_ERROR("0003", "支付流水错误"),
    DUPLICATE_TRADE_CODE("0004", "重复的支付流水号"),
    PAYMENT_FAIL("0005", "支付失败"),
    PAYMENT_TRADE_CODE_GEN_ERROR("0006", "生成支付流水号失败"),
    PAYMENT_FREQUENT("0007", "超过过于频繁，请稍后再试"),
    DUPLICATE_PAYMENT("0008", "该笔交易已完成，请勿重复交易"),
    LOCK_ERROR("0009", "锁支付流水时发生错误"),
    ALIPAY_ERROR("0010", "支付宝错误"),
    WX_ERROR("0011", "微信支付错误"),
    CANCEL_FAIL("0012", "支付取消失败"),
    REFUND_FAIL("0013", "退款失败"),
    PAID_TRADE_NONEXISTENT_ERROR("0014", "已支付流水记录不存在"),
    EXCEEDING_TOTAL_AMOUNT_ERROR("0015", "退款超过支付总金额"),
    THIRD_PARTY_REFUND_FAIL("0016", "第三方退款失败"),
    AMOUNT_LESS_ZERO_ERROR("0017", "金额不能小于0"),
    SHOUQIANBA_ERROR("0018", "收钱吧支付错误"),

    // business
    YCK_NON_EXISTENT_ERROR("10000", "未开通存款账号"),
    YCK_WRONG_PASSWD_ERROR("10001", "支付密码有误"),
    YCK_CONSUMPTION_ERROR("10002", "扣除存款失败"),
    YCK_WRONG_BALANCE_ERROR("10003", "当前余额不足"),

    //微信会员卡
    WX_CARD_UPLOAD_IMG_ERROR("2001", "微信会员卡图片上传异常"),
    WX_CARD_MEMBER_OPEN_TEMPLATE_ERROR("2002", "会员卡模板创建失败"),
    WX_CARD_PLATFORM_KEY_QUERY_ERROR("2003", "平台KEY获取失败"),
    WX_CARD_PLATFORM_KEY_UPDATING("2004","平台KEY正在更新中"),
    WX_CARD_PLATFORM_KEY_DESERIALIZE_ERROR("2005", "平台证书反序列化解密出错"),
    WX_CARD_VERIFY_SIGNATURE_ERROR("2006", "验签出错"),
    WX_CARD_MEMBER_TEMPLATE_RIGHTS_SET_ERROR("2007", "设置会员卡模板权益项出错"),
    WX_CARD_MEMBER_RIGHTS_SET_ERROR("2008", "设置会员卡权益项出错"),
    WX_CARD_CALLBACK_URL_SET_ERROR("2009", "设置回调接口出错"),
    ;

    private String errorCode;
    private String message;

    PPaymentErrorCodeEnum(String errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    @Override
    public String toString() {
        return this.getErrorCode().toString();
    }

    @Override
    public String getErrorCode() {
        return getPrefix() + errorCode;
    }

    @Override
    public String getMessage() {
        return message;
    }

    @Override
    public String getPrefix() {
        return "P";
    }
}
