package com.thebeastshop.payment.enums;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * @author Paul-xiong
 * @date 2017年11月9日
 * @description 交易类型
 */
public enum PThirdPartyTypeEnum {
    DIRECT(0, "直调"),
    SHOUQIANBA(1, "通过收钱吧"),
    ;

    private Integer code;

    private String name;

    PThirdPartyTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static PThirdPartyTypeEnum getEnumByCode(Integer code) {
        for (PThirdPartyTypeEnum e : PThirdPartyTypeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }

}
