package com.thebeastshop.payment.vo;

import com.thebeastshop.payment.enums.PPaymentStatusEnum;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-12-22 15:45
 */
public class PKafkaTradeVO implements PTrade, Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 1L;
    /**
     * 唯一标识
     */
    private Long id;
    /**
     * 支付流水号
     */
    private String tradeCode;
    /**
     * 会员ID
     */
    private Long memberId;
    /**
     * 外部流水号
     */
    private String outTradeCode;
    /**
     * 渠道号
     */
    private String channelCode;
    /**
     * 访问来源
     */
    private Integer accessWay;
    /**
     * 交易类型
     */
    private Integer transType;
    /**
     * 订单金额
     */
    private BigDecimal orderAmount;
    /**
     * 应付金额
     */
    private BigDecimal paymentAmount;
    /**
     * 银行方优惠金额
     */
    private BigDecimal discountAmount;
    /**
     * 实际支付金额
     */
    private BigDecimal actualPaymentAmount;
    /**
     * 支付渠道
     */
    private Integer paymentChannel;
    /**
     * 支付模式
     */
    private Integer paymentMode;
    /**
     * 支付状态
     */
    private Integer status;
    /**
     * 错误码
     */
    private String errorCode;
    /**
     * 第三方支付流水号
     */
    private String thirdPartyTradeCode;
    /**
     * 第三方返回状态
     */
    private String thirdPartyRespStatus;
    /**
     * 第三方错误码
     */
    private String thirdPartyErrorCode;
    /**
     * 第三方类型
     */
    private Integer thirdPartyType;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 回调时间
     */
    private Date returnTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTradeCode() {
        return tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getOutTradeCode() {
        return outTradeCode;
    }

    public void setOutTradeCode(String outTradeCode) {
        this.outTradeCode = outTradeCode;
    }

    public String getThirdPartyTradeCode() {
        return thirdPartyTradeCode;
    }

    public void setThirdPartyTradeCode(String thirdPartyTradeCode) {
        this.thirdPartyTradeCode = thirdPartyTradeCode;
    }

    @Override
    public Integer getThirdPartyType() {
        return thirdPartyType;
    }

    public void setThirdPartyType(Integer thirdPartyType) {
        this.thirdPartyType = thirdPartyType;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Integer getAccessWay() {
        return accessWay;
    }

    public void setAccessWay(Integer accessWay) {
        this.accessWay = accessWay;
    }

    public Integer getTransType() {
        return transType;
    }

    public void setTransType(Integer transType) {
        this.transType = transType;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public Integer getPaymentChannel() {
        return paymentChannel;
    }

    public void setPaymentChannel(Integer paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public Integer getPaymentMode() {
        return paymentMode;
    }

    public void setPaymentMode(Integer paymentMode) {
        this.paymentMode = paymentMode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getThirdPartyRespStatus() {
        return thirdPartyRespStatus;
    }

    public void setThirdPartyRespStatus(String thirdPartyRespStatus) {
        this.thirdPartyRespStatus = thirdPartyRespStatus;
    }

    public String getThirdPartyErrorCode() {
        return thirdPartyErrorCode;
    }

    public void setThirdPartyErrorCode(String thirdPartyErrorCode) {
        this.thirdPartyErrorCode = thirdPartyErrorCode;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getReturnTime() {
        return returnTime;
    }

    public void setReturnTime(Date returnTime) {
        this.returnTime = returnTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public BigDecimal getOrderAmount() {
        return orderAmount;
    }

    public void setOrderAmount(BigDecimal orderAmount) {
        this.orderAmount = orderAmount;
    }

    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public BigDecimal getActualPaymentAmount() {
        return actualPaymentAmount;
    }

    public void setActualPaymentAmount(BigDecimal actualPaymentAmount) {
        this.actualPaymentAmount = actualPaymentAmount;
    }
}
