package com.thebeastshop.payment.vo;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;
import com.thebeastshop.payment.enums.PPaymentModeEnum;
import com.thebeastshop.payment.enums.PPaymentStatusEnum;
import com.thebeastshop.payment.enums.PTransTypeEnum;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 支付流水
 *
 * @author Paul-xiong
 * @date 2017年11月10日
 * @description 支付交易信息
 */
public class PPaymentTradeVO extends BaseDO implements PTrade {

    /**
     *
     */
    private static final long serialVersionUID = 1L;
    /**
     * 支付流水ID
     */
    private Long id;
    /**
     * 支付流水号
     */
    private String tradeCode;
    /**
     * 支付业务编码
     */
    private String paymentBusinessCode;
    /**
     * 订单号
     */
    private String outTradeCode;
    /**
     * 第三方支付流水号
     */
    private String thirdPartyTradeCode;
    /**
     * 渠道号
     */
    private String channelCode;
    /**
     * 会员ID
     */
    private Long memberId;
    /**
     * 访问来源
     */
    private AccessWayEnum accessWay;
    /**
     * 交易类型
     */
    private PTransTypeEnum transType;
    /**
     * 支付金额
     */
    private BigDecimal paymentAmount;
    /**
     * 支付渠道
     */
    private PPaymentChannelEnum paymentChannel;
    /**
     * 支付模式
     */
    private PPaymentModeEnum paymentMode;
    /**
     * 支付请求文本
     */
    private String requestText;
    /**
     * 支付状态
     */
    private PPaymentStatusEnum status;
    /**
     * 第三方返回信息
     */
    private String responseText;
    /**
     * 错误码
     */
    private String errorCode;
    /**
     * 第三方返回状态
     */
    private String thirdPartyRespStatus;
    /**
     * 第三方错误码
     */
    private String thirdPartyErrorCode;
    /**
     * 备注
     */
    private String remark;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 回调时间
     */
    private Date returnTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTradeCode() {
        return tradeCode;
    }

    public void setTradeCode(String tradeCode) {
        this.tradeCode = tradeCode;
    }

    public String getPaymentBusinessCode() {
        return paymentBusinessCode;
    }

    public void setPaymentBusinessCode(String paymentBusinessCode) {
        this.paymentBusinessCode = paymentBusinessCode;
    }

    public String getOutTradeCode() {
        return outTradeCode;
    }

    public void setOutTradeCode(String outTradeCode) {
        this.outTradeCode = outTradeCode;
    }

    public String getThirdPartyTradeCode() {
        return thirdPartyTradeCode;
    }

    public void setThirdPartyTradeCode(String thirdPartyTradeCode) {
        this.thirdPartyTradeCode = thirdPartyTradeCode;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public AccessWayEnum getAccessWay() {
        return accessWay;
    }

    public void setAccessWay(AccessWayEnum accessWay) {
        this.accessWay = accessWay;
    }

    public PTransTypeEnum getTransType() {
        return transType;
    }

    public void setTransType(PTransTypeEnum transType) {
        this.transType = transType;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public PPaymentChannelEnum getPaymentChannel() {
        return paymentChannel;
    }

    public void setPaymentChannel(PPaymentChannelEnum paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public PPaymentModeEnum getPaymentMode() {
        return paymentMode;
    }

    public void setPaymentMode(PPaymentModeEnum paymentMode) {
        this.paymentMode = paymentMode;
    }

    public String getRequestText() {
        return requestText;
    }

    public void setRequestText(String requestText) {
        this.requestText = requestText;
    }

    public PPaymentStatusEnum getStatus() {
        return status;
    }

    public void setStatus(PPaymentStatusEnum status) {
        this.status = status;
    }

    public String getResponseText() {
        return responseText;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getThirdPartyRespStatus() {
        return thirdPartyRespStatus;
    }

    public void setThirdPartyRespStatus(String thirdPartyRespStatus) {
        this.thirdPartyRespStatus = thirdPartyRespStatus;
    }

    public String getThirdPartyErrorCode() {
        return thirdPartyErrorCode;
    }

    public void setThirdPartyErrorCode(String thirdPartyErrorCode) {
        this.thirdPartyErrorCode = thirdPartyErrorCode;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getReturnTime() {
        return returnTime;
    }

    public void setReturnTime(Date returnTime) {
        this.returnTime = returnTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

}
