package com.thebeastshop.payment.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;

import java.util.List;

/**
 * 业主支付渠道
 *
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-12-15 18:10
 */
public class PYzPaymentDTO extends PPaymentDTO {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    /**
     * 商城券列表
     */
    private List<MarketCoupon> marketCoupons;

    public PYzPaymentDTO() {
        super(PPaymentChannelEnum.YEZHU);
    }

    public List<MarketCoupon> getMarketCoupons() {
        return marketCoupons;
    }

    public void setMarketCoupons(List<MarketCoupon> marketCoupons) {
        this.marketCoupons = marketCoupons;
    }

    /**
     * 商城券
     */
    public class MarketCoupon extends BaseDO {
        /**
         * 商场券ID
         */
        private String id;
        /**
         * 数量
         */
        private int count;
        /**
         * 券码
         */
        private List<String> codes;

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public int getCount() {
            return count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public List<String> getCodes() {
            return codes;
        }

        public void setCodes(List<String> codes) {
            this.codes = codes;
        }
    }

}
