package com.thebeastshop.payment.dto;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.payment.enums.PRefundChannelEnum;
import com.thebeastshop.payment.enums.PTransTypeEnum;

import java.math.BigDecimal;

/**
 * 支付退款DTO
 *
 * @author Paul-xiong
 * @date 2018年6月19日
 * @description
 */
public class PRefundDTO extends BaseDO {

    /**
     * 访问来源
     */
    private AccessWayEnum accessWay = AccessWayEnum.UNKNOWN;
    /**
     * 渠道号
     */
    private String channelCode;
    /**
     * 渠道名称
     */
    private String channelName;
    /**
     * 交易类型
     */
    private PTransTypeEnum transType = PTransTypeEnum.ORDER_REFUND;
    /**
     * 会员ID
     */
    private Long memberId;
    /**
     * 退款渠道
     */
    private PRefundChannelEnum refundChannel;
    /**
     * 支付费用
     */
    private BigDecimal paymentAmount;
    /**
     * 外部流水号
     */
    private String outTradeCode;
    /**
     * 业务编号
     */
    private String paymentBusinessCode;
    /**
     * 操作人ID
     */
    private Integer operatorId;
    /**
     * 操作人名称
     */
    private String operatorName;
    /**
     * 备注
     */
    private String remark;

    public AccessWayEnum getAccessWay() {
        return accessWay;
    }

    public void setAccessWay(AccessWayEnum accessWay) {
        this.accessWay = accessWay;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public PTransTypeEnum getTransType() {
        return transType;
    }

    public void setTransType(PTransTypeEnum transType) {
        this.transType = transType;
    }

    public Long getMemberId() {
        return memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public PRefundChannelEnum getRefundChannel() {
        return refundChannel;
    }

    public void setRefundChannel(PRefundChannelEnum refundChannel) {
        this.refundChannel = refundChannel;
    }

    public BigDecimal getPaymentAmount() {
        return paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public String getOutTradeCode() {
        return outTradeCode;
    }

    public void setOutTradeCode(String outTradeCode) {
        this.outTradeCode = outTradeCode;
    }

    public String getPaymentBusinessCode() {
        return paymentBusinessCode;
    }

    public void setPaymentBusinessCode(String paymentBusinessCode) {
        this.paymentBusinessCode = paymentBusinessCode;
    }

    public Integer getOperatorId() {
        return operatorId;
    }

    public void setOperatorId(Integer operatorId) {
        this.operatorId = operatorId;
    }

    public String getOperatorName() {
        return operatorName;
    }

    public void setOperatorName(String operatorName) {
        this.operatorName = operatorName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }
}
