package com.thebeastshop.payment.dto;

import com.thebeastshop.payment.enums.PPaymentChannelEnum;

/**
 * @author Paul-xiong
 * @date 2017年12月15日
 * @description 支付宝WAP跨境即时支付渠道
 */
public class PAliWapCrossBorderDirectPaymentDTO extends PPaymentDTO {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * 支付返回链接
	 */
	private String returnUrl;

	/**
	 * 包含SKU名称和相应数量的货物信息，格式为SKU_name^quantity。如果存在多个商品，则使用竖线(|)分隔值
	 * eg: pencil^2|eraser^5|iPhone XS 256G^1
	 */
	private String goodsInfo;

	/**
	 * 订单中所有货物的总数量
	 */
	private String totalQuantity;

	public PAliWapCrossBorderDirectPaymentDTO() {
		super(PPaymentChannelEnum.ALI_WAP_CROSS_BORDER_DIRECT);
	}

	public String getReturnUrl() {
		return returnUrl;
	}

	public void setReturnUrl(String returnUrl) {
		this.returnUrl = returnUrl;
	}

	public String getGoodsInfo() {
		return goodsInfo;
	}

	public void setGoodsInfo(String goodsInfo) {
		this.goodsInfo = goodsInfo;
	}

	public String getTotalQuantity() {
		return totalQuantity;
	}

	public void setTotalQuantity(String totalQuantity) {
		this.totalQuantity = totalQuantity;
	}
}
