package com.thebeastshop.payment.vo;

import java.math.BigDecimal;

import com.thebeastshop.common.BaseDO;
import com.thebeastshop.payment.enums.PPaymentChannelEnum;

/**
 * 第三方支付信息
 * 
 * @author Paul-xiong
 * @date 2017年11月10日
 * @description
 */
public class PThirdPaymentInfoVO extends BaseDO {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	/**
	 * 支付金额
	 */
	private BigDecimal paymentAmount;
	/**
	 * 支付渠道
	 */
	private PPaymentChannelEnum paymentChannel;
	/**
	 * 第三方支付请求信息
	 */
	private String thirdPaymentRequest;

	/**
	 * 第三方支付返回信息
	 */
	private String thirdPaymentResponse;

	public BigDecimal getPaymentAmount() {
		return paymentAmount;
	}

	public void setPaymentAmount(BigDecimal paymentAmount) {
		this.paymentAmount = paymentAmount;
	}

	public PPaymentChannelEnum getPaymentChannel() {
		return paymentChannel;
	}

	public void setPaymentChannel(PPaymentChannelEnum paymentChannel) {
		this.paymentChannel = paymentChannel;
	}

	public String getThirdPaymentRequest() {
		return thirdPaymentRequest;
	}

	public void setThirdPaymentRequest(String thirdPaymentRequest) {
		this.thirdPaymentRequest = thirdPaymentRequest;
	}

	public String getThirdPaymentResponse() {
		return thirdPaymentResponse;
	}

	public void setThirdPaymentResponse(String thirdPaymentResponse) {
		this.thirdPaymentResponse = thirdPaymentResponse;
	}

}
