package com.thebeastshop.payment.enums;

import com.google.common.collect.Lists;

import java.util.List;

/**
 * @author Paul-xiong
 * @date 2017年11月9日
 * @description 交易类型
 */
public enum PTransTypeEnum {
	ORDER_PAY(1, "订单支付"),
	ORDER_REFUND(2, "订单退款"),
	EXCHANGE_PAY(3, "兑换支付"),
	GROUP_PAY(4, "团购支付"),
	GROUP_REFUND(5, "团购退款"),
	YCK_RECHARGE(6, "预存款充值"),
	;
	
	/**
	 * 支付类型数组
	 */
	public static final List<PTransTypeEnum> PAY_TYPE_ARRAYS = Lists.newArrayList(ORDER_PAY, EXCHANGE_PAY, GROUP_PAY);

	/**
	 * 退款类型数组
	 */
	public static final List<PTransTypeEnum> REFUND_TYPE_ARRAYS = Lists.newArrayList(ORDER_REFUND, GROUP_REFUND);

    private Integer code;

    private String name;

    PTransTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static PTransTypeEnum getEnumByCode(Integer code) {
        for (PTransTypeEnum e : PTransTypeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
    
}
