package com.thebeastshop.payment.enums;

import com.thebeastshop.common.exception.BaseErrorCode;

/**
 * @author Paul-xiong
 * @date 2017年11月10日
 * @description 错误编码
 */
public enum PPaymentErrorCodeEnum implements BaseErrorCode {
	PARAM_ERROR("0001", "参数错误"),
	SYSTEM_ERROR("0002", "系统错误"),
	TRADE_ERROR("0003", "支付流水错误"),
	DUPLICATE_TRADE_CODE("0004", "重复的支付流水号"),
	PAYMENT_FAIL("0005", "支付失败"),
	PAYMENT_TRADE_CODE_GEN_ERROR("0006", "生成支付流水号失败"),
	PAYMENT_FREQUENT("0007", "超过过于频繁，请稍后再试"),
	DUPLICATE_PAYMENT("0008", "该笔支付已完成，请勿重复支付"),
	LOCK_ERROR("0009", "锁支付流水时发生错误"),
	ALIPAY_ERROR("0010", "支付宝错误"),
	WX_ERROR("0011", "微信支付错误"),
	CANCEL_FAIL("0012", "支付取消失败"),
	YCK_NON_EXISTENT_ERROR("10000", "未开通存款账号"),
	YCK_WRONG_PASSWD_ERROR("10001", "支付密码有误"),
	YCK_CONSUMPTION_ERROR("10002", "扣除存款失败"),
	YCK_WRONG_BALANCE_ERROR("10003","当前余额不足"),
	;
	
	private String errorCode;
	private String message;

	PPaymentErrorCodeEnum(String errorCode, String message) {
		this.errorCode = errorCode;
		this.message = message;
	}
	
	@Override
	public String toString() {
		return this.getErrorCode().toString();
	}

	@Override
	public String getErrorCode() {
		return getPrefix() + errorCode;
	}

	@Override
	public String getMessage() {
		return message;
	}

	@Override
	public String getPrefix() {
		return "P";
	}
}
